/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.semver.jgit.api;

import com.xenoterracide.gradle.semver.jgit.annotations.NonNull;
import com.xenoterracide.gradle.semver.jgit.annotations.Nullable;
import com.xenoterracide.gradle.semver.jgit.api.TransportCommand;
import com.xenoterracide.gradle.semver.jgit.api.errors.GitAPIException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidConfigurationException;
import com.xenoterracide.gradle.semver.jgit.api.errors.InvalidRemoteException;
import com.xenoterracide.gradle.semver.jgit.api.errors.JGitInternalException;
import com.xenoterracide.gradle.semver.jgit.api.errors.TransportException;
import com.xenoterracide.gradle.semver.jgit.errors.ConfigInvalidException;
import com.xenoterracide.gradle.semver.jgit.errors.NoRemoteRepositoryException;
import com.xenoterracide.gradle.semver.jgit.errors.NotSupportedException;
import com.xenoterracide.gradle.semver.jgit.internal.JGitText;
import com.xenoterracide.gradle.semver.jgit.lib.NullProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.ProgressMonitor;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.lib.StoredConfig;
import com.xenoterracide.gradle.semver.jgit.lib.SubmoduleConfig;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.submodule.SubmoduleWalk;
import com.xenoterracide.gradle.semver.jgit.transport.FetchResult;
import com.xenoterracide.gradle.semver.jgit.transport.RefSpec;
import com.xenoterracide.gradle.semver.jgit.transport.TagOpt;
import com.xenoterracide.gradle.semver.jgit.transport.Transport;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;
    private Callback callback;
    private boolean isForceUpdate;
    private String initialBranch;
    private Integer depth;
    private Instant deepenSince;
    private List<String> shallowExcludes = new ArrayList<String>();
    private boolean unshallow;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    private SubmoduleConfig.FetchRecurseSubmodulesMode getRecurseMode(String path) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig.FetchRecurseSubmodulesMode mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "submodule", path, "fetchRecurseSubmodules");
        if (mode != null) {
            return mode;
        }
        mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules");
        if (mode != null) {
            return mode;
        }
        return SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchSubmodules(FetchResult results) throws TransportException, GitAPIException, InvalidConfigurationException {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try {
                RevWalk revWalk;
                SubmoduleWalk walk = new SubmoduleWalk(this.repo);
                try {
                    ObjectId fetchHead;
                    block32: {
                        revWalk = new RevWalk(this.repo);
                        fetchHead = this.repo.resolve("FETCH_HEAD");
                        if (fetchHead == null) {
                            if (revWalk != null) {
                                revWalk.close();
                            }
                            if (walk == null) return;
                            walk.close();
                            return;
                        }
                        if (revWalk.parseAny(fetchHead).getType() != 3) break block32;
                        if (revWalk != null) {
                            revWalk.close();
                        }
                        if (walk == null) return;
                        walk.close();
                        return;
                    }
                    walk.setTree(revWalk.parseTree(fetchHead));
                    while (walk.next()) {
                        Throwable throwable2 = null;
                        Object var8_14 = null;
                        try (Repository submoduleRepo = walk.getRepository();){
                            SubmoduleConfig.FetchRecurseSubmodulesMode recurseMode;
                            if (submoduleRepo == null || walk.getModulesPath() == null || walk.getConfigUrl() == null || ((recurseMode = this.getRecurseMode(walk.getPath())) != SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND || submoduleRepo.getObjectDatabase().has(walk.getObjectId())) && recurseMode != SubmoduleConfig.FetchRecurseSubmodulesMode.YES) continue;
                            FetchCommand f = new FetchCommand(submoduleRepo).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.applyOptions(this.refSpecs)).setDryRun(this.dryRun).setRecurseSubmodules(recurseMode);
                            this.configure(f);
                            if (this.callback != null) {
                                this.callback.fetchingSubmodule(walk.getPath());
                            }
                            results.addSubmodule(walk.getPath(), f.call());
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                                throw throwable2;
                            }
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                            throw throwable2;
                        }
                    }
                    break block33;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (walk == null) throw throwable;
                    walk.close();
                    throw throwable;
                }
                {
                    block33: {
                        finally {
                            if (revWalk != null) {
                                revWalk.close();
                            }
                        }
                    }
                    if (walk == null) return;
                    walk.close();
                    return;
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_7 = null;
            try (Transport transport = Transport.open(this.repo, this.remote);){
                transport.setCheckFetchedObjects(this.checkFetchedObjects);
                transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
                transport.setDryRun(this.dryRun);
                if (this.tagOption != null) {
                    transport.setTagOpt(this.tagOption);
                }
                transport.setFetchThin(this.thin);
                if (this.depth != null) {
                    transport.setDepth(this.depth);
                }
                if (this.unshallow) {
                    if (this.depth != null) {
                        throw new IllegalStateException(JGitText.get().depthWithUnshallow);
                    }
                    transport.setDepth(Integer.MAX_VALUE);
                }
                if (this.deepenSince != null) {
                    transport.setDeepenSince(this.deepenSince);
                }
                transport.setDeepenNots(this.shallowExcludes);
                this.configure(transport);
                FetchResult result = transport.fetch(this.monitor, this.applyOptions(this.refSpecs), this.initialBranch);
                if (!this.repo.isBare()) {
                    this.fetchSubmodules(result);
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoRemoteRepositoryException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (com.xenoterracide.gradle.semver.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e);
        }
    }

    private List<RefSpec> applyOptions(List<RefSpec> refSpecs2) {
        if (!this.isForceUpdate()) {
            return refSpecs2;
        }
        ArrayList<RefSpec> updated = new ArrayList<RefSpec>(3);
        for (RefSpec refSpec : refSpecs2) {
            updated.add(refSpec.setForceUpdate(true));
        }
        return updated;
    }

    public FetchCommand setRecurseSubmodules(@Nullable SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.checkCallable();
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public FetchCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result = false;
        StoredConfig config = this.repo.getConfig();
        result = config.getBoolean("fetch", null, "prune", result);
        result = config.getBoolean("remote", this.remote, "prune", result);
        return result;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(String ... specs) {
        return this.setRefSpecs(Arrays.stream(specs).map(RefSpec::new).collect(Collectors.toList()));
    }

    public FetchCommand setRefSpecs(RefSpec ... specs) {
        return this.setRefSpecs(Arrays.asList(specs));
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thinPack) {
        this.checkCallable();
        this.thin = thinPack;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public FetchCommand setInitialBranch(String branch) {
        this.initialBranch = branch;
        return this;
    }

    public FetchCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public FetchCommand setForceUpdate(boolean force) {
        this.isForceUpdate = force;
        return this;
    }

    public FetchCommand setDepth(int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException(JGitText.get().depthMustBeAt1);
        }
        this.depth = depth;
        return this;
    }

    public FetchCommand setShallowSince(@NonNull OffsetDateTime shallowSince) {
        this.deepenSince = shallowSince.toInstant();
        return this;
    }

    public FetchCommand setShallowSince(@NonNull Instant shallowSince) {
        this.deepenSince = shallowSince;
        return this;
    }

    public FetchCommand addShallowExclude(@NonNull String shallowExclude) {
        this.shallowExcludes.add(shallowExclude);
        return this;
    }

    public FetchCommand addShallowExclude(@NonNull ObjectId shallowExclude) {
        this.shallowExcludes.add(shallowExclude.name());
        return this;
    }

    public FetchCommand setUnshallow(boolean unshallow) {
        this.unshallow = unshallow;
        return this;
    }

    void setShallowExcludes(List<String> shallowExcludes) {
        this.shallowExcludes = shallowExcludes;
    }

    public static interface Callback {
        public void fetchingSubmodule(String var1);
    }
}

