/*
 * Decompiled with CFR 0.152.
 */
package com.xenoterracide.gradle.git;

import com.xenoterracide.gradle.git.GitRemote;
import com.xenoterracide.gradle.semver.jgit.lib.ObjectId;
import com.xenoterracide.gradle.semver.jgit.lib.Ref;
import com.xenoterracide.gradle.semver.jgit.lib.Repository;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevCommit;
import com.xenoterracide.gradle.semver.jgit.revwalk.RevWalk;
import com.xenoterracide.gradle.semver.jgit.revwalk.filter.RevFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

class MergeBaseFinder {
    private final Repository repo;

    MergeBaseFinder(Repository repo) {
        this.repo = repo;
    }

    public Optional<ObjectId> find(@Nullable GitRemote gitRemote) {
        if (gitRemote == null || gitRemote.headBranch() == null) {
            return Optional.empty();
        }
        ObjectId current = Optional.ofNullable(this.repo.findRef("HEAD")).map(Ref::getObjectId).orElseThrow();
        ObjectId remote = Optional.ofNullable(this.repo.findRef(gitRemote.headBranchRefName())).map(Ref::getObjectId).orElseThrow();
        RevWalk walk = new RevWalk(this.repo);
        try {
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(List.of(walk.parseCommit(remote), walk.parseCommit(current)));
            RevCommit mergeBase = walk.next();
            Optional<ObjectId> optional = Optional.ofNullable(mergeBase).map(ObjectId::toObjectId);
            walk.close();
            return optional;
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

