/*
 * Decompiled with CFR 0.152.
 */
package com.xdandroid.materialprogressview;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.xdandroid.materialprogressview.CircleImageView;
import com.xdandroid.materialprogressview.MaterialProgressDrawable;

public class MaterialProgressView
extends ViewGroup {
    protected CircleImageView mCircleView;
    protected MaterialProgressDrawable mProgress;
    protected static final int CIRCLE_BG_LIGHT = -328966;
    protected static final int CIRCLE_DIAMETER = 40;
    protected int mCircleWidth;
    protected int mCircleHeight;
    protected int mExtraShadowSpace;

    public MaterialProgressView(Context context) {
        super(context);
        this.initProgressView();
    }

    public MaterialProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initProgressView();
    }

    public MaterialProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initProgressView();
    }

    @RequiresApi(api=21)
    public MaterialProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initProgressView();
    }

    protected void initProgressView() {
        this.setWillNotDraw(false);
        this.createProgressView();
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleHeight = this.mCircleWidth = (int)(40.0f * metrics.density);
        this.mExtraShadowSpace = (int)(5.332 * (double)metrics.density);
        this.setVisibility(0);
    }

    protected void createProgressView() {
        this.mCircleView = new CircleImageView(this.getContext(), -328966, 20.0f);
        this.mProgress = new MaterialProgressDrawable(this.getContext(), (View)this);
        this.mProgress.setBackgroundColor(-328966);
        this.mCircleView.setImageDrawable(this.mProgress);
        this.mCircleView.getBackground().setAlpha(255);
        this.mProgress.setAlpha(255);
        this.addView((View)this.mCircleView);
    }

    public void setProgressBackgroundColor(@ColorInt int color) {
        this.mCircleView.setBackgroundColor(color);
        this.mProgress.setBackgroundColor(color);
    }

    public void setColorSchemeColors(@ColorInt int[] colors) {
        this.mProgress.setColorSchemeColors(colors);
    }

    public void setVisibility(int visibility) {
        if (visibility == 8 || visibility == 4) {
            this.mCircleView.clearAnimation();
            this.mProgress.stop();
        } else {
            this.mProgress.start();
            this.mProgress.showArrow(true);
        }
        super.setVisibility(visibility);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int width = this.getMeasuredWidth();
        int circleWidth = this.mCircleView.getMeasuredWidth();
        int circleHeight = this.mCircleView.getMeasuredHeight();
        this.mCircleView.layout(width / 2 - circleWidth / 2, 0, width / 2 + circleWidth / 2, circleHeight);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.mCircleWidth + this.mExtraShadowSpace, this.mCircleHeight + this.mExtraShadowSpace);
        this.mCircleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleHeight, (int)0x40000000));
    }
}

