/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import com.google.gson.Gson;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttributeMapper {
    private Deserializer deserializer;
    private Gson gson;

    public AttributeMapper() {
        this.deserializer = new Deserializer();
        this.gson = new Gson();
    }

    public AttributeMapper(Deserializer deserializer, Gson gson) {
        this.deserializer = deserializer;
        this.gson = gson;
    }

    public void mapAttributeToObject(Resource jsonApiResource, JSONObject attributesJsonObject, Field field, String jsonFieldName) {
        Object object = null;
        try {
            object = attributesJsonObject.get(jsonFieldName);
        }
        catch (JSONException e) {
            Logger.debug("JSON attributes does not contain " + jsonFieldName);
            return;
        }
        if (object instanceof JSONArray) {
            List<Object> list = null;
            try {
                list = this.createListFromJSONArray(attributesJsonObject.getJSONArray(jsonFieldName), field);
            }
            catch (JSONException e) {
                Logger.debug(jsonFieldName + " is not an valid JSONArray.");
            }
            this.deserializer.setField(jsonApiResource, field.getName(), list);
        } else if (object.getClass() == JSONObject.class) {
            Object obj = this.gson.fromJson(object.toString(), field.getType());
            this.deserializer.setField(jsonApiResource, field.getName(), obj);
        } else {
            this.deserializer.setField(jsonApiResource, field.getName(), object);
        }
    }

    private List<Object> createListFromJSONArray(JSONArray jsonArray, Field field) {
        Type genericFieldType = field.getGenericType();
        ArrayList<Object> objectArrayList = new ArrayList<Object>();
        if (genericFieldType instanceof ParameterizedType) {
            Type[] fieldArgTypes;
            ParameterizedType aType = (ParameterizedType)genericFieldType;
            for (Type fieldArgType : fieldArgTypes = aType.getActualTypeArguments()) {
                Class fieldArgClass = (Class)fieldArgType;
                for (int i = 0; jsonArray.length() > i; ++i) {
                    Object obj = null;
                    Object jsonObject = null;
                    try {
                        jsonObject = jsonArray.get(i);
                    }
                    catch (JSONException e) {
                        Logger.debug("JSONArray does not contain index " + i + ".");
                        continue;
                    }
                    if (fieldArgClass == String.class) {
                        obj = jsonObject.toString();
                    } else {
                        try {
                            obj = this.gson.fromJson(jsonArray.get(i).toString(), fieldArgClass);
                        }
                        catch (JSONException e) {
                            Logger.debug("JSONArray does not contain index " + i + ".");
                        }
                    }
                    objectArrayList.add(obj);
                }
            }
        }
        return objectArrayList;
    }

    public HashMap<String, Object> createMapFromJSONObject(JSONObject jsonObject) {
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                metaMap.put(key, jsonObject.get(key));
            }
            catch (JSONException e) {
                Logger.debug("JSON does not contain " + key + ".");
            }
        }
        return metaMap;
    }
}

