/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Annotations.Relationship;
import at.rags.morpheus.AttributeMapper;
import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Error;
import at.rags.morpheus.ErrorLinks;
import at.rags.morpheus.Exceptions.NotExtendingResourceException;
import at.rags.morpheus.Factory;
import at.rags.morpheus.Links;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import at.rags.morpheus.Serializer;
import at.rags.morpheus.Source;
import com.google.gson.annotations.SerializedName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Mapper {
    private Deserializer deserializer;
    private Serializer serializer;
    private AttributeMapper attributeMapper;

    public Mapper() {
        this.deserializer = new Deserializer();
        this.serializer = new Serializer();
        this.attributeMapper = new AttributeMapper();
    }

    public Mapper(Deserializer deserializer, Serializer serializer, AttributeMapper attributeMapper) {
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.attributeMapper = attributeMapper;
    }

    public Links mapLinks(JSONObject linksJsonObject) {
        Links links = new Links();
        try {
            links.setSelfLink(linksJsonObject.getString("self"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain self");
        }
        try {
            links.setRelated(linksJsonObject.getString("related"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain related");
        }
        try {
            links.setFirst(linksJsonObject.getString("first"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain first");
        }
        try {
            links.setLast(linksJsonObject.getString("last"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain last");
        }
        try {
            links.setPrev(linksJsonObject.getString("prev"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain prev");
        }
        try {
            links.setNext(linksJsonObject.getString("next"));
        }
        catch (JSONException e) {
            Logger.debug("JSON link does not contain next");
        }
        return links;
    }

    public Resource mapId(Resource object, JSONObject jsonDataObject) throws NotExtendingResourceException {
        try {
            return this.deserializer.setIdField(object, jsonDataObject.get("id"));
        }
        catch (JSONException e) {
            Logger.debug("JSON data does not contain id.");
            return object;
        }
    }

    public Resource mapAttributes(Resource object, JSONObject attributesJsonObject) {
        if (attributesJsonObject == null) {
            return object;
        }
        for (Field field : object.getClass().getDeclaredFields()) {
            String jsonFieldName = field.getName();
            boolean isRelation = false;
            for (Annotation annotation : field.getAnnotations()) {
                if (annotation.annotationType() == SerializedName.class) {
                    SerializedName serializeName = (SerializedName)annotation;
                    jsonFieldName = serializeName.value();
                }
                if (annotation.annotationType() != Relationship.class) continue;
                isRelation = true;
            }
            if (isRelation) continue;
            this.attributeMapper.mapAttributeToObject(object, attributesJsonObject, field, jsonFieldName);
        }
        return object;
    }

    public Resource mapRelations(Resource object, JSONObject jsonObject, List<Resource> included) throws Exception {
        HashMap<String, String> relationshipNames = this.getRelationshipNames(object.getClass());
        for (String relationship : relationshipNames.keySet()) {
            JSONObject relationJsonObject = null;
            try {
                relationJsonObject = jsonObject.getJSONObject(relationship);
            }
            catch (JSONException e) {
                Logger.debug("Relationship named " + relationship + "not found in JSON");
                continue;
            }
            JSONObject relationDataObject = null;
            try {
                relationDataObject = relationJsonObject.getJSONObject("data");
                Resource relationObject = Factory.newObjectFromJSONObject(relationDataObject, null);
                relationObject = this.matchIncludedToRelation(relationObject, included);
                this.deserializer.setField(object, relationshipNames.get(relationship), relationObject);
            }
            catch (JSONException e) {
                Logger.debug("JSON relationship does not contain data");
            }
            JSONArray relationDataArray = null;
            try {
                relationDataArray = relationJsonObject.getJSONArray("data");
                List<Resource> relationArray = Factory.newObjectFromJSONArray(relationDataArray, null);
                relationArray = this.matchIncludedToRelation(relationArray, included);
                this.deserializer.setField(object, relationshipNames.get(relationship), relationArray);
            }
            catch (JSONException e) {
                Logger.debug("JSON relationship does not contain data");
            }
        }
        return object;
    }

    public Resource matchIncludedToRelation(Resource object, List<Resource> included) {
        if (included == null) {
            return object;
        }
        for (Resource resource : included) {
            if (!object.getId().equals(resource.getId()) || !object.getClass().equals(resource.getClass())) continue;
            return resource;
        }
        return object;
    }

    public List<Resource> matchIncludedToRelation(List<Resource> relationResources, List<Resource> included) {
        ArrayList<Resource> matchedResources = new ArrayList<Resource>();
        for (Resource resource : relationResources) {
            matchedResources.add(this.matchIncludedToRelation(resource, included));
        }
        return matchedResources;
    }

    public List<Error> mapErrors(JSONArray errorArray) {
        ArrayList<Error> errors = new ArrayList<Error>();
        for (int i = 0; errorArray.length() > i; ++i) {
            JSONObject errorJsonObject;
            try {
                errorJsonObject = errorArray.getJSONObject(i);
            }
            catch (JSONException e) {
                Logger.debug("No index " + i + " in error json array");
                continue;
            }
            Error error = new Error();
            try {
                error.setId(errorJsonObject.getString("id"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain id");
            }
            try {
                error.setStatus(errorJsonObject.getString("status"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain status");
            }
            try {
                error.setCode(errorJsonObject.getString("code"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain code");
            }
            try {
                error.setTitle(errorJsonObject.getString("title"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain title");
            }
            try {
                error.setDetail(errorJsonObject.getString("detail"));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain detail");
            }
            JSONObject sourceJsonObject = null;
            try {
                sourceJsonObject = errorJsonObject.getJSONObject("source");
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain source");
            }
            if (sourceJsonObject != null) {
                Source source = new Source();
                try {
                    source.setParameter(sourceJsonObject.getString("parameter"));
                }
                catch (JSONException e) {
                    Logger.debug("JSON object does not contain parameter");
                }
                try {
                    source.setPointer(sourceJsonObject.getString("pointer"));
                }
                catch (JSONException e) {
                    Logger.debug("JSON object does not contain pointer");
                }
                error.setSource(source);
            }
            try {
                JSONObject linksJsonObject = errorJsonObject.getJSONObject("links");
                ErrorLinks links = new ErrorLinks();
                links.setAbout(linksJsonObject.getString("about"));
                error.setLinks(links);
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain links or about");
            }
            try {
                error.setMeta(this.attributeMapper.createMapFromJSONObject(errorJsonObject.getJSONObject("meta")));
            }
            catch (JSONException e) {
                Logger.debug("JSON object does not contain JSONObject meta");
            }
            errors.add(error);
        }
        return errors;
    }

    public ArrayList<HashMap<String, Object>> createData(List<Resource> resources, boolean includeAttributes) {
        String resourceName = null;
        try {
            resourceName = this.nameForResourceClass(resources.get(0).getClass());
        }
        catch (Exception e) {
            Logger.debug(e.getMessage());
            return null;
        }
        ArrayList<HashMap<String, Object>> dataArray = new ArrayList<HashMap<String, Object>>();
        for (Resource resource : resources) {
            HashMap<String, Object> relationships;
            HashMap<String, Object> attributes = this.serializer.getFieldsAsDictionary(resource);
            HashMap<String, Object> resourceRepresentation = new HashMap<String, Object>();
            resourceRepresentation.put("type", resourceName);
            resourceRepresentation.put("id", resource.getId());
            if (includeAttributes) {
                resourceRepresentation.put("attributes", attributes);
            }
            if ((relationships = this.createRelationships(resource)) != null) {
                resourceRepresentation.put("relationships", relationships);
            }
            dataArray.add(resourceRepresentation);
        }
        return dataArray;
    }

    public HashMap<String, Object> createData(Resource resource, boolean includeAttributes) {
        HashMap<String, Object> relationships;
        HashMap<String, Object> attributes;
        String resourceName = null;
        try {
            resourceName = this.nameForResourceClass(resource.getClass());
        }
        catch (Exception e) {
            Logger.debug(e.getMessage());
            return null;
        }
        HashMap<String, Object> resourceRepresentation = new HashMap<String, Object>();
        resourceRepresentation.put("type", resourceName);
        resourceRepresentation.put("id", resource.getId());
        if (includeAttributes && (attributes = this.serializer.getFieldsAsDictionary(resource)) != null) {
            resourceRepresentation.put("attributes", attributes);
        }
        if ((relationships = this.createRelationships(resource)) != null) {
            resourceRepresentation.put("relationships", relationships);
        }
        if (resource.getLinks() != null) {
            resourceRepresentation.put("links", this.createLinks(resource));
        }
        return resourceRepresentation;
    }

    public HashMap<String, Object> createRelationships(Resource resource) {
        HashMap<String, Object> relations = this.serializer.getRelationships(resource);
        HashMap<String, Object> relationships = new HashMap<String, Object>();
        for (String relationshipName : relations.keySet()) {
            ArrayList<HashMap<String, Object>> dataArray;
            HashMap<String, Cloneable> dataObject;
            HashMap<String, Object> data;
            Object relationObject = relations.get(relationshipName);
            if (relationObject instanceof Resource && (data = this.createData((Resource)relationObject, false)) != null) {
                dataObject = new HashMap<String, Cloneable>();
                dataObject.put("data", data);
                relationships.put(relationshipName, dataObject);
            }
            if (!(relationObject instanceof ArrayList) || (dataArray = this.createData((List)relationObject, false)) == null) continue;
            dataObject = new HashMap();
            dataObject.put("data", dataArray);
            relationships.put(relationshipName, dataObject);
        }
        if (relationships.isEmpty()) {
            relationships = null;
        }
        return relationships;
    }

    public HashMap<String, Object> createLinks(Resource resource) {
        HashMap<String, String> links = null;
        Links resourceLinks = resource.getLinks();
        if (resourceLinks != null) {
            links = new HashMap<String, String>();
            if (resourceLinks.getSelfLink() != null) {
                links.put("self", resourceLinks.getSelfLink());
            }
            if (resourceLinks.getRelated() != null) {
                links.put("related", resourceLinks.getRelated());
            }
            if (resourceLinks.getFirst() != null) {
                links.put("first", resourceLinks.getFirst());
            }
            if (resourceLinks.getLast() != null) {
                links.put("last", resourceLinks.getLast());
            }
            if (resourceLinks.getPrev() != null) {
                links.put("prev", resourceLinks.getPrev());
            }
            if (resourceLinks.getNext() != null) {
                links.put("next", resourceLinks.getNext());
            }
            if (resourceLinks.getAbout() != null) {
                links.put("about", resourceLinks.getAbout());
            }
        }
        return links;
    }

    public ArrayList<HashMap<String, Object>> createIncluded(Resource resource) {
        HashMap<String, Object> relations = this.serializer.getRelationships(resource);
        ArrayList<HashMap<String, Object>> includes = new ArrayList<HashMap<String, Object>>();
        for (String relationshipName : relations.keySet()) {
            ArrayList<HashMap<String, Object>> dataArray;
            HashMap<String, Object> data;
            Object relationObject = relations.get(relationshipName);
            if (relationObject instanceof Resource && (data = this.createData((Resource)relationObject, true)) != null) {
                includes.add(data);
            }
            if (!(relationObject instanceof ArrayList) || (dataArray = this.createData((List)relationObject, true)) == null) continue;
            includes.addAll(dataArray);
        }
        return includes;
    }

    private HashMap<String, String> getRelationshipNames(Class clazz) {
        HashMap<String, String> relationNames = new HashMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            String fieldName = field.getName();
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (annotation.annotationType() == SerializedName.class) {
                    SerializedName serializeName = (SerializedName)annotation;
                    fieldName = serializeName.value();
                }
                if (annotation.annotationType() != Relationship.class) continue;
                Relationship relationshipAnnotation = (Relationship)annotation;
                relationNames.put(relationshipAnnotation.value(), fieldName);
            }
        }
        return relationNames;
    }

    private String nameForResourceClass(Class clazz) throws Exception {
        for (String key : Deserializer.getRegisteredClasses().keySet()) {
            if (Deserializer.getRegisteredClasses().get(key) != clazz) continue;
            return key;
        }
        throw new Exception("Class " + clazz.getSimpleName() + " not registered.");
    }

    public Deserializer getDeserializer() {
        return this.deserializer;
    }

    public AttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }
}

