/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Exceptions.NotExtendingResourceException;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import java.lang.reflect.Field;
import java.util.HashMap;

public class Deserializer {
    private static HashMap<String, Class> registeredClasses = new HashMap();

    public static void registerResourceClass(String typeName, Class resourceClass) {
        registeredClasses.put(typeName, resourceClass);
    }

    public Resource createObjectFromString(String resourceName) throws InstantiationException, IllegalAccessException, NotExtendingResourceException {
        Class objectClass = registeredClasses.get(resourceName);
        try {
            return (Resource)objectClass.newInstance();
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new NotExtendingResourceException(objectClass + " is not inheriting Resource");
        }
    }

    public Resource setField(Resource resourceObject, String fieldName, Object data) {
        Field field = null;
        try {
            field = resourceObject.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(resourceObject, data);
        }
        catch (NoSuchFieldException e) {
            Logger.debug("Field " + fieldName + " not found.");
        }
        catch (IllegalAccessException e) {
            Logger.debug("Could not access " + field.getName() + " field");
        }
        return resourceObject;
    }

    public Resource setIdField(Resource resourceObject, Object data) throws NotExtendingResourceException {
        Class superClass = null;
        superClass = this.getMorpheusResourceSuperClass(resourceObject);
        try {
            Field field = superClass.getDeclaredField("Id");
            field.setAccessible(true);
            if (data instanceof String) {
                field.set(resourceObject, data);
            } else {
                field.set(resourceObject, String.valueOf(data));
            }
        }
        catch (NoSuchFieldException e) {
            Logger.debug("No field Id found. That should not happened.");
        }
        catch (IllegalAccessException e) {
            Logger.debug("Could not access field Id");
        }
        return resourceObject;
    }

    private Class getMorpheusResourceSuperClass(Resource resourceObject) throws NotExtendingResourceException {
        Class<?> superClass = resourceObject.getClass().getSuperclass();
        while (superClass != Resource.class && (superClass = superClass.getSuperclass()) != null) {
        }
        if (superClass == null) {
            throw new NotExtendingResourceException(resourceObject.getClass() + " is not inheriting Resource");
        }
        return superClass;
    }

    public static HashMap<String, Class> getRegisteredClasses() {
        return registeredClasses;
    }

    public static void setRegisteredClasses(HashMap<String, Class> registeredClasses) {
        Deserializer.registeredClasses = registeredClasses;
    }
}

