/*
 * Decompiled with CFR 0.152.
 */
package at.rags.morpheus;

import at.rags.morpheus.Deserializer;
import at.rags.morpheus.Logger;
import at.rags.morpheus.Resource;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttributeMapper {
    private Deserializer mDeserializer;

    public AttributeMapper() {
        this.mDeserializer = new Deserializer();
    }

    public AttributeMapper(Deserializer deserializer) {
        this.mDeserializer = deserializer;
    }

    public void mapAttributeToObject(Resource jsonApiResource, JSONObject attributesJsonObject, Field field, String jsonFieldName) {
        try {
            if (attributesJsonObject.get(jsonFieldName).getClass() == JSONArray.class) {
                List<Object> list = this.createListFromJSONArray(attributesJsonObject.getJSONArray(jsonFieldName));
                this.mDeserializer.setField(jsonApiResource, field.getName(), list);
            } else if (attributesJsonObject.get(jsonFieldName).getClass() == JSONObject.class) {
                JSONObject objectForMap = attributesJsonObject.getJSONObject(jsonFieldName);
                this.mDeserializer.setField(jsonApiResource, field.getName(), this.createMapFromJSONObject(objectForMap));
            } else {
                this.mDeserializer.setField(jsonApiResource, field.getName(), attributesJsonObject.get(jsonFieldName));
            }
        }
        catch (JSONException e) {
            Logger.debug("JSON attributes does not contain " + jsonFieldName);
        }
    }

    private List<Object> createListFromJSONArray(JSONArray jsonArray) {
        ArrayList<Object> attributeAsList = new ArrayList<Object>();
        for (int i = 0; jsonArray.length() > i; ++i) {
            try {
                attributeAsList.add(jsonArray.get(i));
                continue;
            }
            catch (JSONException e) {
                Logger.debug("JSONArray does not contain Object at index " + i);
            }
        }
        return attributeAsList;
    }

    public HashMap<String, Object> createMapFromJSONObject(JSONObject jsonObject) {
        HashMap<String, Object> metaMap = new HashMap<String, Object>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                metaMap.put(key, jsonObject.get(key));
            }
            catch (JSONException e) {
                Logger.debug("JSON does not contain " + key + ".");
            }
        }
        return metaMap;
    }
}

