/*
 * Decompiled with CFR 0.152.
 */
package com.android.xamoom.htmltextview;

import android.graphics.Color;
import android.text.TextPaint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020\tJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\tH\u0002R*\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR@\u0010\u000f\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\bj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\bj\b\u0012\u0004\u0012\u00020\u0003`\n`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR*\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR.\u0010\u0015\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160\bj\n\u0012\u0006\u0012\u0004\u0018\u00010\u0016`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000eR*\u0010\u0019\u001a\u0012\u0012\u0004\u0012\u00020\u00030\bj\b\u0012\u0004\u0012\u00020\u0003`\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u000e\u00a8\u0006&"}, d2={"Lcom/android/xamoom/htmltextview/HtmlTable;", "", "html", "", "paint", "Landroid/text/TextPaint;", "(Ljava/lang/String;Landroid/text/TextPaint;)V", "cellSizes", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getCellSizes", "()Ljava/util/ArrayList;", "setCellSizes", "(Ljava/util/ArrayList;)V", "cellsPerRow", "getCellsPerRow", "setCellsPerRow", "largestCellSize", "getLargestCellSize", "setLargestCellSize", "rowBackgroundColors", "", "getRowBackgroundColors", "setRowBackgroundColors", "rows", "getRows", "setRows", "getRowStyle", "element", "Lorg/jsoup/nodes/Element;", "(Lorg/jsoup/nodes/Element;)Ljava/lang/Integer;", "maximalRowSize", "parseTable", "", "updateLargestCellSize", "index", "size", "htmltextview_release"})
public final class HtmlTable {
    @NotNull
    private ArrayList<String> rows;
    @NotNull
    private ArrayList<ArrayList<String>> cellsPerRow;
    @NotNull
    private ArrayList<Integer> rowBackgroundColors;
    @NotNull
    private ArrayList<Float> cellSizes;
    @NotNull
    private ArrayList<Float> largestCellSize;

    @NotNull
    public final ArrayList<String> getRows() {
        return this.rows;
    }

    public final void setRows(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.rows = arrayList;
    }

    @NotNull
    public final ArrayList<ArrayList<String>> getCellsPerRow() {
        return this.cellsPerRow;
    }

    public final void setCellsPerRow(@NotNull ArrayList<ArrayList<String>> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.cellsPerRow = arrayList;
    }

    @NotNull
    public final ArrayList<Integer> getRowBackgroundColors() {
        return this.rowBackgroundColors;
    }

    public final void setRowBackgroundColors(@NotNull ArrayList<Integer> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.rowBackgroundColors = arrayList;
    }

    @NotNull
    public final ArrayList<Float> getCellSizes() {
        return this.cellSizes;
    }

    public final void setCellSizes(@NotNull ArrayList<Float> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.cellSizes = arrayList;
    }

    @NotNull
    public final ArrayList<Float> getLargestCellSize() {
        return this.largestCellSize;
    }

    public final void setLargestCellSize(@NotNull ArrayList<Float> arrayList) {
        Intrinsics.checkParameterIsNotNull(arrayList, (String)"<set-?>");
        this.largestCellSize = arrayList;
    }

    private final void parseTable(String html, TextPaint paint) {
        Document document = Jsoup.parse((String)html);
        Elements rows = document.select("tr");
        for (Element element : rows) {
            this.rows.add(element.outerHtml());
            Element element2 = element;
            Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"element");
            this.rowBackgroundColors.add(this.getRowStyle(element2));
            ArrayList<String> cellList = new ArrayList<String>();
            Elements cells = element.select("td");
            int count = 0;
            for (Element cell : cells) {
                cellList.add(cell.toString());
                float size = paint.measureText(cell.html());
                this.updateLargestCellSize(count, size);
                ++count;
            }
            this.cellsPerRow.add(cellList);
        }
        this.cellSizes.addAll((Collection<Float>)this.largestCellSize);
    }

    private final void updateLargestCellSize(int index, float size) {
        block6: {
            block5: {
                if (this.largestCellSize.size() == index) break block5;
                Float f = this.largestCellSize.get(index);
                Intrinsics.checkExpressionValueIsNotNull((Object)f, (String)"largestCellSize[index]");
                if (!(size > ((Number)f).floatValue())) break block6;
            }
            if (CollectionsKt.getOrNull((List)this.largestCellSize, (int)index) == null) {
                this.largestCellSize.add(index, Float.valueOf(size));
            } else {
                this.largestCellSize.set(index, Float.valueOf(size));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Integer getRowStyle(Element element) {
        void $receiver$iv$iv;
        Iterable $receiver$iv = (Iterable)element.attributes();
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Attribute it = (Attribute)element$iv$iv;
            if (!StringsKt.contains((CharSequence)it.html(), (CharSequence)"bgcolor", (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        iterator = $receiver$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Attribute it = (Attribute)element$iv;
            String colorString = it.getValue();
            if (!StringsKt.contains$default((CharSequence)colorString, (CharSequence)"#", (boolean)false, (int)2, null)) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "#%s";
                Object[] objectArray = new Object[]{colorString};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
                colorString = string2;
            }
            return Color.parseColor((String)colorString);
        }
        return null;
    }

    public final float maximalRowSize() {
        float fullsize = CollectionsKt.sumOfFloat((Iterable)this.cellSizes);
        return fullsize;
    }

    public HtmlTable(@NotNull String html, @NotNull TextPaint paint) {
        Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
        Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
        this.rows = new ArrayList();
        this.cellsPerRow = new ArrayList();
        this.rowBackgroundColors = new ArrayList();
        this.cellSizes = new ArrayList();
        this.largestCellSize = new ArrayList();
        this.parseTable(html, paint);
    }
}

