/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.FilterArgs;
import com.x5.template.filters.ListFilter;
import com.x5.template.filters.SplitFilter;
import java.util.ArrayList;
import java.util.List;

public class SliceFilter
extends ListFilter {
    public String getFilterName() {
        return "slice";
    }

    private static int parseSliceArg(String arg, int defaultVal, int len) {
        int x = defaultVal;
        if (arg != null && arg.trim().length() > 0) {
            try {
                x = Integer.parseInt(arg.trim());
                if (len >= 0 && x < 0) {
                    x = len + x < 0 ? 0 : len + x;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return x;
    }

    public Object transformList(Chunk chunk, List list, FilterArgs arg) {
        int to;
        int from;
        int step;
        if (list == null) {
            return list;
        }
        int len = list.size();
        String fromArg = null;
        String endArg = null;
        String stepArg = null;
        String firstArg = null;
        String[] args = arg.getFilterArgs();
        if (args.length > 0) {
            firstArg = args[0];
            String[] sliceArgs = SplitFilter.splitNonRegex(firstArg, ":");
            boolean colonDelim = sliceArgs.length > 1;
            fromArg = sliceArgs[0];
            if (colonDelim) {
                endArg = sliceArgs[1];
                if (sliceArgs.length > 2) {
                    stepArg = sliceArgs[2];
                }
            } else if (args.length > 1) {
                endArg = args[1];
                if (args.length > 2) {
                    stepArg = args[2];
                }
            }
            from = SliceFilter.parseSliceArg(fromArg, (step = SliceFilter.parseSliceArg(stepArg, 1, -1)) < 0 ? len - 1 : 0, len);
            to = SliceFilter.parseSliceArg(endArg, step < 0 ? -1 : len, len);
            if (from > len) {
                from = len;
            }
            if (step == 0) {
                step = 1;
                to = from;
            }
            if (step > 0 && to < from || step < 0 && to > from) {
                to = from;
            }
            if (to > len) {
                to = len;
            }
        } else {
            from = 0;
            to = len;
            step = 1;
        }
        return SliceFilter.slice(list, from, to, step);
    }

    public static Object slice(List list, int from, int to, int step) {
        if (step == 1) {
            return list.subList(from, to);
        }
        ArrayList stepped = new ArrayList();
        int i = from;
        while (!(step > 0 ? i >= to : i <= to)) {
            stepped.add(list.get(i));
            i += step;
        }
        return stepped;
    }
}

