/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OnMatchFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, FilterArgs args) {
        String result = OnMatchFilter.applyMatchTransform(chunk, text, args);
        return result;
    }

    public String getFilterName() {
        return "onmatch";
    }

    private static String applyMatchTransform(Chunk context, String text, FilterArgs arg) {
        String[] args = arg.getFilterArgs();
        if (args == null) {
            return text;
        }
        if (args.length == 1 && args[0] != null && args[0].length() == 0) {
            return text;
        }
        int i = 0;
        while (i < args.length) {
            if (i + 1 >= args.length) {
                return text;
            }
            String test = args[i];
            String value = args[i + 1];
            if (test.equals("|nomatch|")) {
                return FilterArgs.magicBraces(context, value);
            }
            if (text != null) {
                Pattern p;
                Matcher m;
                int patternStart = test.indexOf(47) + 1;
                int patternEnd = test.lastIndexOf(47);
                if (patternStart < 0 || patternStart == patternEnd) {
                    return text;
                }
                boolean ignoreCase = false;
                boolean multiLine = false;
                boolean dotAll = false;
                String pattern = test.substring(patternStart, patternEnd);
                int c = test.length() - 1;
                while (c > patternEnd) {
                    char option = test.charAt(c);
                    if (option == 'i') {
                        ignoreCase = true;
                    }
                    if (option == 'm') {
                        multiLine = true;
                    }
                    if (option == 's') {
                        dotAll = true;
                    }
                    --c;
                }
                if (multiLine) {
                    pattern = "(?m)" + pattern;
                }
                if (ignoreCase) {
                    pattern = "(?i)" + pattern;
                }
                if (dotAll) {
                    pattern = "(?s)" + pattern;
                }
                if ((m = (p = Pattern.compile(pattern)).matcher(text)).find()) {
                    return FilterArgs.magicBraces(context, value);
                }
            }
            i += 2;
        }
        return "";
    }
}

