/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.BasicFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.FilterArgs;

public class QuickCalcFilter
extends BasicFilter
implements ChunkFilter {
    public String transformText(Chunk chunk, String text, FilterArgs args) {
        Object calc = null;
        return QuickCalcFilter.applyQuickCalc(text, args.getUnparsedArgs());
    }

    public String getFilterName() {
        return "qcalc";
    }

    private static String applyQuickCalc(String text, String calc) {
        if (text == null) {
            return null;
        }
        if (calc == null) {
            return text;
        }
        try {
            if (text.indexOf(".") > 0 || calc.indexOf(".") > 0) {
                double x = Double.parseDouble(text);
                char op = calc.charAt(0);
                double y = Double.parseDouble(calc.substring(1));
                double z = x;
                if (op == '-') {
                    z = x - y;
                }
                if (op == '+') {
                    z = x + y;
                }
                if (op == '*') {
                    z = x * y;
                }
                if (op == '/') {
                    z = x / y;
                }
                if (op == '%') {
                    z = x % y;
                }
                return Double.toString(z);
            }
            long x = Long.parseLong(text);
            char op = calc.charAt(0);
            long y = Long.parseLong(calc.substring(1));
            long z = x;
            if (op == '-') {
                z = x - y;
            }
            if (op == '+') {
                z = x + y;
            }
            if (op == '*') {
                z = x * y;
            }
            if (op == '/') {
                z = x / y;
            }
            if (op == '%') {
                z = x % y;
            }
            if (op == '^') {
                z = Math.round(Math.pow(x, y));
            }
            return Long.toString(z);
        }
        catch (NumberFormatException e) {
            return text;
        }
    }
}

