/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.Chunk;
import com.x5.template.SnippetPart;
import com.x5.template.SnippetTag;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockTag {
    public abstract void renderBlock(Writer var1, Chunk var2, int var3) throws IOException;

    public abstract String getBlockStartMarker();

    public abstract String getBlockEndMarker();

    private static int locateTag(List<SnippetPart> parts, String tagToMatch, int startAt) {
        for (int i = startAt; i < parts.size(); ++i) {
            SnippetTag tag;
            String tagText;
            SnippetPart part = parts.get(i);
            if (!part.isTag() || (tagText = (tag = (SnippetTag)part).getTag()) == null || !tagText.startsWith(tagToMatch)) continue;
            return i;
        }
        return -1;
    }

    public static int findMatchingBlockEnd(BlockTag helper, List<SnippetPart> parts, int startAt) {
        String endBlock = helper.getBlockEndMarker();
        String scanFor = "." + endBlock;
        String beginBlock = helper.getBlockStartMarker();
        String nestedScanFor = "." + beginBlock;
        int nestDepth = 0;
        int nestedBlockPos = BlockTag.locateTag(parts, nestedScanFor, startAt);
        int endMarkerPos = BlockTag.locateTag(parts, scanFor, startAt);
        if (nestedBlockPos > -1 && nestedBlockPos < endMarkerPos) {
            ++nestDepth;
        }
        while (nestDepth > 0 && endMarkerPos > 0) {
            while (nestedBlockPos > -1 && nestedBlockPos < endMarkerPos) {
                if ((nestedBlockPos = BlockTag.locateTag(parts, nestedScanFor, nestedBlockPos + 1)) <= -1 || nestedBlockPos >= endMarkerPos) continue;
                ++nestDepth;
            }
            --nestDepth;
            endMarkerPos = BlockTag.locateTag(parts, scanFor, endMarkerPos + 1);
            if (nestedBlockPos <= -1 || nestedBlockPos >= endMarkerPos) continue;
            ++nestDepth;
        }
        return endMarkerPos;
    }

    public boolean hasBody(String openingTag) {
        return true;
    }

    public boolean doSmartTrimAroundBlock() {
        return false;
    }
}

