/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template.filters;

import com.x5.template.Chunk;
import com.x5.template.filters.AlternateFilter;
import com.x5.template.filters.Base64DecodeFilter;
import com.x5.template.filters.Base64EncodeFilter;
import com.x5.template.filters.CalcFilter;
import com.x5.template.filters.CheckedFilter;
import com.x5.template.filters.ChunkFilter;
import com.x5.template.filters.DefangFilter;
import com.x5.template.filters.EscapeXMLFilter;
import com.x5.template.filters.ExecFilter;
import com.x5.template.filters.FormatFilter;
import com.x5.template.filters.HexFilter;
import com.x5.template.filters.HexUpperFilter;
import com.x5.template.filters.IndentFilter;
import com.x5.template.filters.LetterCaseFilter;
import com.x5.template.filters.MD5Base64Filter;
import com.x5.template.filters.MD5HexFilter;
import com.x5.template.filters.OnDefinedFilter;
import com.x5.template.filters.OnEmptyFilter;
import com.x5.template.filters.OnMatchFilter;
import com.x5.template.filters.OrdinalSuffixFilter;
import com.x5.template.filters.QuickCalcFilter;
import com.x5.template.filters.RegexFilter;
import com.x5.template.filters.SHA1Base64Filter;
import com.x5.template.filters.SHA1HexFilter;
import com.x5.template.filters.SelectedFilter;
import com.x5.template.filters.TranslateFilter;
import com.x5.template.filters.URLDecodeFilter;
import com.x5.template.filters.URLEncodeFilter;
import com.x5.template.filters.UnescapeXMLFilter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicFilter
implements ChunkFilter {
    public static ChunkFilter[] stockFilters = new ChunkFilter[]{new AlternateFilter(), new Base64DecodeFilter(), new Base64EncodeFilter(), new CalcFilter(), new CheckedFilter(), new DefangFilter(), new EscapeXMLFilter(), new UnescapeXMLFilter(), new ExecFilter(), new FormatFilter(), new HexFilter(), new HexUpperFilter(), new IndentFilter(), new LetterCaseFilter(), new MD5HexFilter(), new MD5Base64Filter(), new OnEmptyFilter(), new OnDefinedFilter(), new OnMatchFilter(), new OrdinalSuffixFilter(), new QuickCalcFilter(), new RegexFilter(), new SelectedFilter(), new SHA1HexFilter(), new SHA1Base64Filter(), new TranslateFilter(), new URLDecodeFilter(), new URLEncodeFilter()};

    @Override
    public abstract String transformText(Chunk var1, String var2, String[] var3);

    @Override
    public abstract String getFilterName();

    @Override
    public String[] getFilterAliases() {
        return null;
    }

    @Override
    public String transformObject(Chunk chunk, Object object, String[] args) {
        String stringifiedObject = object == null ? null : object.toString();
        return this.transformText(chunk, stringifiedObject, args);
    }

    public static Map<String, ChunkFilter> getStockFilters() {
        HashMap<String, ChunkFilter> filters = new HashMap<String, ChunkFilter>();
        for (ChunkFilter filter : stockFilters) {
            filters.put(filter.getFilterName(), filter);
            String[] aliases = filter.getFilterAliases();
            if (aliases == null) continue;
            for (String alias : aliases) {
                filters.put(alias, filter);
            }
        }
        return filters;
    }
}

