/*
 * Decompiled with CFR 0.152.
 */
package com.x5.template;

import com.x5.template.BlockTag;
import com.x5.template.Chunk;
import com.x5.template.IfTag;
import com.x5.template.LocaleTag;
import com.x5.template.LoopTag;
import com.x5.template.MacroTag;
import com.x5.template.Snippet;
import com.x5.template.SnippetPart;
import java.io.IOException;
import java.io.Writer;

public class SnippetTag
extends SnippetPart {
    protected String tag;
    private static final BlockTag[] BLOCK_TAGS = new BlockTag[]{new LoopTag(), new IfTag(), new LocaleTag(), new MacroTag()};
    private static final String[] BLOCK_TAG_TOKENS = SnippetTag.extractTagTokens(BLOCK_TAGS);

    public SnippetTag(String text, String tag) {
        super(text);
        this.tag = tag;
    }

    public boolean isTag() {
        return true;
    }

    public String getTag() {
        return this.tag;
    }

    public void render(Writer out, Chunk rules, int depth) throws IOException {
        if (this.depthCheckFails(depth, out)) {
            return;
        }
        Object tagValue = null;
        tagValue = rules.resolveTagValue(this.tag, depth);
        if (tagValue == null) {
            out.append(this.snippetText);
        } else if (tagValue instanceof Snippet) {
            ((Snippet)tagValue).render(out, rules, depth);
        } else if (tagValue instanceof String) {
            Snippet compiled = Snippet.getSnippet((String)tagValue);
            compiled.render(out, rules, depth + 1);
        } else {
            rules.explodeToPrinter(out, tagValue, depth + 1);
        }
    }

    private static String[] extractTagTokens(BlockTag[] blockTags) {
        String[] tokens = new String[blockTags.length];
        for (int i = 0; i < blockTags.length; ++i) {
            tokens[i] = "." + blockTags[i].getBlockStartMarker();
        }
        return tokens;
    }

    public BlockTag getBlockTagType() {
        for (int i = 0; i < BLOCK_TAG_TOKENS.length; ++i) {
            if (!this.tag.startsWith(BLOCK_TAG_TOKENS[i])) continue;
            if (BLOCK_TAGS[i].hasBody(this.tag)) {
                return BLOCK_TAGS[i];
            }
            return null;
        }
        return null;
    }
}

