/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.LogMessageBuilder;

public class RequestLogMessageBuilder
extends LogMessageBuilder {
    private final String method;
    private final String uri;

    public RequestLogMessageBuilder(String requestId, String method, String uri) {
        super(requestId);
        this.method = method;
        this.uri = uri;
    }

    @Override
    public String getMessage() {
        String messageTemplateWithoutBody = "Outgoing request (requestId='%s'):%n  method:       '%s'%n  uri:          '%s'%n  headers:      '%s'";
        String messageTemplateWithBody = "Outgoing request (requestId='%s'):%n  method:       '%s'%n  uri:          '%s'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'";
        String body = this.body();
        if (body == null) {
            return String.format("Outgoing request (requestId='%s'):%n  method:       '%s'%n  uri:          '%s'%n  headers:      '%s'", this.requestId(), this.emptyIfNull(this.method), this.emptyIfNull(this.uri), this.headers());
        }
        return String.format("Outgoing request (requestId='%s'):%n  method:       '%s'%n  uri:          '%s'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'", this.requestId(), this.emptyIfNull(this.method), this.emptyIfNull(this.uri), this.headers(), this.emptyIfNull(this.contentType()), body);
    }
}

