/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.ApiResource;
import com.onlinepayments.ClientInterface;
import com.onlinepayments.Communicator;
import com.onlinepayments.logging.CommunicatorLogger;
import com.onlinepayments.merchant.MerchantClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class Client
extends ApiResource
implements ClientInterface {
    public static final String API_VERSION = "v2";
    private static final Charset CHARSET = Charset.forName("UTF-8");

    public Client(Communicator communicator) {
        this(communicator, null);
    }

    private Client(Communicator communicator, String clientMetaInfo) {
        super(communicator, clientMetaInfo, null);
    }

    @Override
    public Client withClientMetaInfo(String clientMetaInfo) {
        if (this.clientMetaInfo == null && clientMetaInfo == null) {
            return this;
        }
        if (clientMetaInfo == null) {
            return new Client(this.communicator, null);
        }
        this.communicator.getMarshaller().unmarshal(clientMetaInfo, Object.class);
        clientMetaInfo = Base64.encodeBase64String((byte[])clientMetaInfo.getBytes(CHARSET));
        if (clientMetaInfo.equals(this.clientMetaInfo)) {
            return this;
        }
        return new Client(this.communicator, clientMetaInfo);
    }

    @Override
    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        this.communicator.closeIdleConnections(idleTime, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.communicator.closeExpiredConnections();
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        this.communicator.enableLogging(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.communicator.disableLogging();
    }

    @Override
    public void close() throws IOException {
        this.communicator.close();
    }

    @Override
    public MerchantClient merchant(String merchantId) {
        TreeMap<String, String> subContext = new TreeMap<String, String>();
        subContext.put("merchantId", merchantId);
        return new MerchantClient(this, subContext);
    }
}

