/*
 * Decompiled with CFR 0.152.
 */
package com.ec.v2.utlis;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.config.Config;
import com.ec.v2.entity.SignEntity;
import com.ec.v2.entity.customer.file.CrmFileUploadVo;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    public static HttpPost buidPostRequest(String paramsJson, String postUrl) {
        Config config = Config.get();
        StringEntity postingString = new StringEntity(paramsJson, config.getEncoding());
        HttpPost post = new HttpPost(postUrl);
        post.setEntity((HttpEntity)postingString);
        post.setHeader("Content-type", "application/json");
        Long timeStamp = System.currentTimeMillis();
        SignEntity sign = SignEntity.setSignParam(timeStamp, config);
        post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
        post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
        post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
        return post;
    }

    public static HttpPost buidUploadRequest(CrmFileUploadVo params, String postUrl) {
        Config config = Config.get();
        HttpPost post = new HttpPost(postUrl);
        Long timeStamp = System.currentTimeMillis();
        SignEntity sign = SignEntity.setSignParam(timeStamp, config);
        post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
        post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
        post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (File file : params.getFiles()) {
            FileBody fileBin = new FileBody(file);
            builder.addPart("file", (ContentBody)fileBin);
        }
        builder.addTextBody("optUserId", params.getOptUserId() + "");
        builder.addTextBody("crmId", params.getCrmId() + "");
        HttpEntity reqEntity = builder.build();
        post.setEntity(reqEntity);
        return post;
    }

    public static HttpPost buidPostRequest(String postUrl) {
        Config config = Config.get();
        HttpPost post = new HttpPost(postUrl);
        post.setHeader("Content-type", "application/json");
        Long timeStamp = System.currentTimeMillis();
        SignEntity sign = SignEntity.setSignParam(timeStamp, config);
        post.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
        post.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
        post.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
        return post;
    }

    public static String buildUrl(String url) {
        return Config.get().getDomain() + url;
    }

    public static String post(String params, String url) throws IOException {
        HttpPost post = HttpUtils.buidPostRequest(params, url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)Config.get().getEncoding());
    }

    public static String crmFileUpload(CrmFileUploadVo params, String url) throws IOException {
        HttpPost post = HttpUtils.buidUploadRequest(params, url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)Config.get().getEncoding());
    }

    public static String post(String url) throws IOException {
        HttpPost post = HttpUtils.buidPostRequest(url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)post);
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)Config.get().getEncoding());
    }

    public static String get(String url) throws IOException {
        HttpGet get = HttpUtils.buidGetRequest(url);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute((HttpUriRequest)get);
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)Config.get().getEncoding());
    }

    public static String get(String url, Object dto) throws IOException {
        String jsonStr = JSONObject.toJSONString((Object)dto);
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        String parmas = HttpUtils.buildGetParmas(json);
        url = url + "?" + parmas;
        return HttpUtils.get(url);
    }

    private static String buildGetParmas(JSONObject json) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String key : json.keySet()) {
            String strVal;
            Object val = json.get((Object)key);
            if (val == null || (strVal = val.toString()).trim().equals("")) continue;
            if (i > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(strVal);
            ++i;
        }
        return new String(sb);
    }

    public static HttpGet buidGetRequest(String postUrl) {
        Config config = Config.get();
        HttpGet get = new HttpGet(postUrl);
        get.setHeader("Content-type", "application/json");
        Long timeStamp = System.currentTimeMillis();
        SignEntity sign = SignEntity.setSignParam(timeStamp, config);
        get.setHeader("X-Ec-Cid", sign.getX_EC_CID() + "");
        get.setHeader("X-Ec-TimeStamp", sign.getX_EC_TIMESTAMP() + "");
        get.setHeader("X-Ec-Sign", sign.getX_EC_SIGN());
        return get;
    }
}

