package com.ec.v2.service.statistics;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.statistics.DigitalMapDto;
import com.ec.v2.entity.statistics.DigitalMapResp;
import com.ec.v2.entity.statistics.HistogramDto;
import com.ec.v2.entity.statistics.HistogramResp;
import com.ec.v2.entity.statistics.parmas.TagParam;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;

/**
 * 
 * @Title: Tag.java
 * @Description: 标签分析
 * @author shicy
 * @date 2020-04-21 11:22:55
 */
public class Tag {

    /**
     * 标签数字图
     * @param dto
     * @return
     * @throws IOException
     */
    public static DigitalMapResp digitalMap(DigitalMapDto<TagParam> dto) throws IOException {
        // 1.构建 接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.TAG_DIGITALMAP);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, DigitalMapResp.class);
    }

    /**
     * 标签柱状图
     * @param dto
     * @return
     * @throws IOException
     */
    public static HistogramResp histogram(HistogramDto<TagParam> dto) throws IOException {
        // 1.构建 接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.TAG_HISTOGRAM);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, HistogramResp.class);
    }

}
