package com.ec.v2.service.statistics;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.statistics.DigitalMapDto;
import com.ec.v2.entity.statistics.DigitalMapResp;
import com.ec.v2.entity.statistics.LineGraphDto;
import com.ec.v2.entity.statistics.LineGraphResp;
import com.ec.v2.entity.statistics.parmas.CrmQuantityParam;
import com.ec.v2.entity.statistics.parmas.PhoneParam;
import com.ec.v2.utlis.HttpUtils;

import java.io.IOException;

/**
 * @Description: 电话分析
 * @author ZhouFuYang
 */
public class Phone {

    /**
     * 电话数字图
     * @param dto
     * @return
     * @throws IOException
     */
    public static DigitalMapResp digitalMap(DigitalMapDto<PhoneParam> dto) throws IOException {
        // 1.构建 接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.PHONE_DIGITALMAP);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, DigitalMapResp.class);
    }

    /**
     * 电话折线图
     * @param dto
     * @return
     * @throws IOException
     */
    public static LineGraphResp lineGraph(LineGraphDto<PhoneParam> dto) throws IOException {
        // 1.构建 接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.STATISTICS.PHONE_LINEGRAPH);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, LineGraphResp.class);
    }
}
