package com.ec.v2.service;

import java.io.IOException;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.ec.v2.entity.customer.*;
import com.ec.v2.entity.sales.SaleDetailResponse;
import com.ec.v2.entity.sales.SalesResponse;
import org.apache.http.client.ClientProtocolException;

import com.alibaba.fastjson.JSONObject;
import com.ec.v2.constact.UrlConstants;
import com.ec.v2.entity.MsgResponse;
import com.ec.v2.entity.customer.highquery.HighQueryDto;
import com.ec.v2.entity.customer.highquery.HighQueryResp;
import com.ec.v2.utlis.HttpUtils;

/**
 * @author shicy
 * @Title: Customer.java
 * @Description: 客户相关接口， 包括
 * <p>2. 批量查询客户信息:/v2/customer/addCustomer </p>
 * <p>1. 查询客户标签 :   /v2/customer/queryLabel </p>
 * <p>2. 批量查询客户信息: /v2/customer/preciseQuery </p>
 * @date 2020-03-24 11:23:08
 */
public class Customer {

    // 批量创建客户
    public static AddCustomerResp addCustomer(AddCustomerVo dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_ADDCUSTOMER);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, AddCustomerResp.class);
    }


    //合并客户复制文档
    //接口地址 /v2/customer/combine
    public static CombineCustomerResp combine(CombineCrmDetailVo dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_COMBINE);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        CombineCustomerResp data = JSONObject.parseObject(str, CombineCustomerResp.class);
        return data;
    }


    //客户分组复制文档
    //接口地址 /v2/customer/getCustomerGroup
    public static QueryCrmGroupResp getCustomerGroup(QueryCrmGroupVo dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.GET_CUSTOMERGROUP);
        // 2. 构建请求参数
        String str = HttpUtils.get(postUrl, dto);
        QueryCrmGroupResp data = JSONObject.parseObject(str, QueryCrmGroupResp.class);
        return data;
    }

    //分页查询客户轨迹复制文档
    //接口地址 /v2/customer/getTrajectory
    public static TrajectoryPageResp getTrajectory(TrajectoryVO dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.GET_TRAJECTORY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        TrajectoryPageResp data = JSONObject.parseObject(str, TrajectoryPageResp.class);
        return data;
    }

    /**
     * @param dto
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     * @Title: preciseQuery
     * @Description: 批量查询客户信息
     * <p>最大批次 支持 200 个 crmid</p>
     * @author shicy
     * @date 2020-03-24 11:21:55
     */
    public static PreciseQueryResp preciseQuery(CrmIdslDto dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_PRECISEQUERY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        PreciseQueryResp data = JSONObject.parseObject(str, PreciseQueryResp.class);
        return data;
    }


    /**
     * @param dto
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     * @Title: preciseQuery
     * @Description: 批量查询客户信息
     * <p>最大批次 支持 200 个 crmid</p>
     * @author shicy
     * @date 2020-03-24 11:21:55
     */
    public static QueryPageResp query(PageQueryVO dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_QUERY);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        QueryPageResp data = JSONObject.parseObject(str, QueryPageResp.class);
        return data;
    }

    /**
     * @param dto 业务入参
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     * @Title: queryLabel
     * @Description: 查询客户标签
     * @author shicy
     * @date 2020-03-23 04:19:14
     */
    public static QueryLabelResp queryLabel(CrmIdslDto dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_QUERYLABEL);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        QueryLabelResp data = JSONObject.parseObject(str, QueryLabelResp.class);
        return data;
    }


    // 修改客户复制文档
//    接口地址 /v2/customer/updateCustomer
    public static MsgResponse updateCustomer(UpdateCustomerVo dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_UPDATECUSTOMER);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        MsgResponse data = JSONObject.parseObject(str, MsgResponse.class);
        return data;
    }

    public static BatchUpdateResp batchUpdateCustomer(List<UpdateCustomerVo> updateCustomerVoList) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_BATCH_UPDATECUSTOMER);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(updateCustomerVoList);
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, BatchUpdateResp.class);
    }

    //  修改客户阶段
//  接口地址  /v2/step/update
    public static UpdateStageResp updateCustomerStep(UpdateStageVO dto) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_UPDATECUSTOMER_STEP);
        // 2. 构建请求参数
        String paramsJson = JSONObject.toJSONString(dto);
        String str = HttpUtils.post(paramsJson, postUrl);
        UpdateStageResp data = JSONObject.parseObject(str, UpdateStageResp.class);
        return data;
    }


    /**
     * @param dto
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     * @Title: highquery
     * @Description: 高级查询
     * @author shicy
     * @date 2020-04-10 09:58:04
     */
    public static HighQueryResp highquery(HighQueryDto dto) throws ClientProtocolException, IOException {
        dto.check();
        String paramsJson = JSONObject.toJSONString(dto);
        return highquery(paramsJson);
    }


    /**
     * @param paramsJson
     * @return
     * @throws ClientProtocolException
     * @throws IOException
     * @Title: highquery
     * @Description: 高级查询
     * @author shicy
     * @date 2020-04-10 09:56:57
     */
    public static HighQueryResp highquery(String paramsJson) throws ClientProtocolException, IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.POST_HIGH_QUERY);
        // 2. 构建请求参数
        String str = HttpUtils.post(paramsJson, postUrl);
        return JSONObject.parseObject(str, HighQueryResp.class);
    }

    /**
     * 获取员工拜访记录
     *
     * @param queryBean
     * @return
     * @throws IOException
     */
    public static CustomerResp<List<CrmVisitDetail>> getCrmVisitDetails(CrmVisitQueryBean queryBean) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.GET_CRM_VISIT_DETAILS);
        // 2. 构建请求参数
        String str = HttpUtils.post(JSON.toJSONString(queryBean), postUrl);
        return JSON.parseObject(str, new TypeReference<CustomerResp<List<CrmVisitDetail>>>() {});
    }

    public static CustomerResp<List<CustomerDeleteDTO>> delcrms(CustomerDeleteVO customerDeleteVO) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.DEL_CRMS);
        // 2. 构建请求参数
        String str = HttpUtils.post(JSON.toJSONString(customerDeleteVO), postUrl);
        return JSON.parseObject(str, new TypeReference<CustomerResp<List<CustomerDeleteDTO>>>() {});
    }

    public static CustomerResp<CrmFieldParamListDTO> getCasCadeFieldMapping(CasCadeFieldVO casCadeFieldVO) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.GET_CASCADE_FIELDMAPPING);
        // 2. 构建请求参数
        String str = HttpUtils.post(JSON.toJSONString(casCadeFieldVO), postUrl);
        return JSON.parseObject(str, new TypeReference<CustomerResp<CrmFieldParamListDTO>>() {});
    }

    public static CustomerResp<List<CrmSourceDTO>> getChannelSource() throws IOException {
        // 1.构建  接口Url
        String getUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.GET_CHANNEL_SOURCE);
        // 2. 构建请求参数
        String str = HttpUtils.get(getUrl);
        return JSON.parseObject(str, new TypeReference<CustomerResp<List<CrmSourceDTO>>>() {});
    }

    public static CustomerResp<List<CrmShareDto>> share(CrmShareVO crmShareVO) throws IOException {
        // 1.构建  接口Url
        String postUrl = HttpUtils.buildUrl(UrlConstants.CUSTOMER.SHARE);
        // 2. 构建请求参数
        String str = HttpUtils.post(JSON.toJSONString(crmShareVO), postUrl);
        return JSON.parseObject(str, new TypeReference<CustomerResp<List<CrmShareDto>>>() {});
    }


}
