package com.ec.v2.entity.trajectory;

import com.alibaba.fastjson.JSONObject;

/**
 * 查询跟进记录
 */
public class SelectFollowRecordRequest {
    /**
     * 部门ID 用分号(;)隔开
     */
    private String deptIds;
    /**
     * 操作员工ID，可输入多个值，用分号(;)隔开
     */
    private String userIds;
    /**
     * 客户的ID，可输入多个值，用分号(;)隔开
     */
    private String crmIds;
    /**
     * 统计开始时间，精确到年月日 （不能查询当天的数据,有需要可使用查询客户轨迹的接口）
     */
    private String startDate;
    /**
     * 统计结束时间，精确到年月日 （不能查询当天的数据,有需要可使用查询客户轨迹的接口）
     */
    private String endDate;
    /**
     * 分页请求时当前请求第几页的数据，从1开始
     */
    private Integer pageNo = 1;

    private Long lastCrmId;

    public Long getLastCrmId() {
        return lastCrmId;
    }

    public void setLastCrmId(Long lastCrmId) {
        this.lastCrmId = lastCrmId;
    }

    public void setDeptIds(String deptIds) {
        this.deptIds = deptIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public void setCrmIds(String crmIds) {
        this.crmIds = crmIds;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    public String getDeptIds() {
        return deptIds;
    }

    public String getUserIds() {
        return userIds;
    }

    public String getCrmIds() {
        return crmIds;
    }

    public String getStartDate() {
        return startDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public Integer getPageNo() {
        return pageNo;
    }

    @Override
    public String toString() {
        return "[crmIds=" + crmIds + ", deptIds=" + deptIds + ", userIds=" + userIds +", startDate=" + startDate +", endDate=" + endDate + "]";
    }

    public JSONObject notPageString() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deptIds",deptIds);
        jsonObject.put("crmIds",crmIds);
        jsonObject.put("startDate",startDate);
        jsonObject.put("endDate",endDate);
        jsonObject.put("userIds",userIds);
        return jsonObject;
    }
}
