package com.ec.v2.entity.statistics.parmas;

import lombok.Data;

import java.util.List;

import com.alibaba.fastjson.JSONObject;

/**
 * 
 * @Title: WorkefficParmas.java
 * @Description: 工作效率相关指标查询 参数
 * @author shicy
 */
@Data
public class WorkefficParmas extends BaseParam {
	/**
	 * @Fields serialVersionUID : TODO
	 * @author shicy
	 * @date 2020-04-13 06:23:54
	 */
	private static final long serialVersionUID = 1214879914270935081L;

	// 501 联系客户数, 502 跟进记录数
	/**
	 *
	 * 有效联系方式：<br/>
	 * 0 全部, 1 微信, 2 QQ, 3 短信, 4 邮件, 5 电话, <br/>
	 * 6 拜访, 7 ec智能名片会话, 8 网站客户会话<br/>
	 */
	private List<Integer> contactType;

	// 503 QQ, 505 拜访, 507 微信

	// 504 短信
	/**
	 * 短信类型<br/>
	 * 0 全部， 1 营销短信，2 普通短信
	 */
	private Integer smsIndexType;

	// 506 邮件
	/**
	 * 邮件类型<br/>
	 * 0 全部， 1 发送，2 接收
	 */
	private Integer mailndexType = 0;

	// 508 电话-拨打次数, 509 电话-通话时长
	/**
	 * 通话类型: 【0:全部, 1:座机 , 2:公费电话 , 3:手机 , 4:EC 云呼, 5:总机, 6:外部电话】
	 */
	protected Integer callType;

	/**
	 * 通话时长类型：【0:全部、 1: 0秒 、 2:(1-30秒)、 3: (31-60秒)、 4: (61-120秒)、 5: (121-180秒)、 6:
	 * (180秒以上)】
	 */
	protected List<Integer> timeType;

	/**
	 * 通话方式：【0:全部 , 1:呼入 , 2: 呼出】
	 */
	protected Integer inoutType;

	// 510 新增订单, 511 成交订单量, 512 成交金额

	// 513 入库客户
	/**
	 * 标签查询类型 <br/>
	 * 1:不限 <br/>
	 * 2:选择标签 <br/>
	 * 3:无标签 <br/>
	 */
	private List<Long> tagsType;
	/**
	 * 标签列表<br/>
	 * 如果tagsType=2， 那么tags 不能为空
	 */
	private List<Long> tags;

	/**
	 * 入库类型 【100 全部、101 新增客户，102 同事转入，103 分配客户，104 回收站还原， 105 公海领取，106 合并客户】<br/>
	 * 如果查询的是 入库客户数 相关指标， 这个参数起作用
	 */
	private List<Integer> inStorageType;

	public static WorkefficParmas newIntance() {
		WorkefficParmas parmas = new WorkefficParmas();
		return parmas;
	}


	public static WorkefficParmas fromJson(String parmasJson) {
		return JSONObject.parseObject(parmasJson, WorkefficParmas.class);
	}

}
