package com.ec.v2.entity.customer.highquery;

import java.util.List;

import lombok.Data;



@Data
public class HighQueryDto extends BaseQueryDto {
	/***
	 * ********* 1. 基本查询能力区域 : 12 个字段 *********
	 */

	/**  
	 * @Fields serialVersionUID : TODO
	 * @author shicy
	 * @date 2020-04-10 10:54:25 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 客户阶段 ， 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Integer> f_step;

	/**
	 * 标签 ， 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_tag_id;

	/**
	 * 跟进人ID ， 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_user_id;

	/**
	 * 客户id ， 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_crm_id;

	/**
	 * 客户创建人id ， 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_crea_userid;
	/**
	 * 性别 ， 单个数字 term 查询
	 */
	private Long f_gender;

	/**
	 * 动态时间 ，支持 range查询
	 */
	private TimeDto f_modify_time;
	/**
	 * 联系时间 ，支持 range查询
	 */
	private TimeDto f_contact_time;
	/**
	 * 创建时间 ，支持 range查询
	 */
	private TimeDto f_create_time;

	/**
	 * 支持 keyword查询
	 */
	private String f_fax;
	/**
	 * 支持 keyword查询
	 */
	private String f_msn;
	/**
	 * 支持 keyword查询
	 */
	private String f_qq;

	/***
	 * ********* 2. 支持最后联系时间查询 : 2 个字段 *********
	 */
	private ContactTime lastContactTime;

	/***
	 * ********* 3. 通讯号码相关查询 : 3 个字段 *********
	 */

	/**
	 * 支持邮箱 精确查询
	 */
	private String f_email;
	/**
	 * 支持手机号码 精确查询
	 */
	private String f_mobile;
	/**
	 * 支持座机 精确查询
	 */
	private String f_phone;

	/***
	 * ********* 4. 支持名称相关查询 ： 姓名， 备注， 公司名称 *********
	 */
	/**
	 * 支持 名称 精确查询
	 */
	private String f_name;
	/**
	 * 支持 备注 精确查询
	 */
	private String f_memo;
	/**
	 * 支持 公司名称 精确查询
	 */
	private String f_company;

	/***
	 * ********* 5. 支持自定义字段查询 *********
	 */

	/**
	 * 自定义字段 文本类型， ， 多个 按照且关系查询
	 */
	private List<FieldInfoText> customFieldText;

	/**
	 * 自定义字段 时间类型， 多个 按照且关系查询
	 */
	private List<FieldInfoDate> customFieldDate;

	/***
	 * ********* 6. flag 相关查询 *********
	 */

	/**
	 * 邮箱标志位查询
	 * <p>
	 * 0 ： 查询没有绑定邮箱的客户
	 * </p>
	 * <p>
	 * 1 ： 查询绑定邮箱的客户
	 * </p>
	 * <p>
	 * 2 ： 查询绑定多个邮箱的客户
	 * </p>
	 */
	private Integer flag_email_nums;
	/**
	 * 邮箱标志位查询
	 * <p>
	 * 0 ： 查询没有绑定手机的客户
	 * </p>
	 * <p>
	 * 1 ： 查询绑定手机的客户
	 * </p>
	 * <p>
	 * 2 ： 查询绑定多个手机的客户
	 * </p>
	 */
	private Integer flag_mobile_nums;

	/***
	 * ********* 6. relation 相关查询 *********
	 */
	/**
	 * 业务组公海 id , 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_business_id;
	/**
	 * 客户来源 id , 单个数字 term 查询， 多个数字 按照 terms 查询
	 */
	private List<Long> f_from;

	public void check() {
		int maxTerms = 200;
		String format = "参数错误: %s 长度大于  %s";
		
		if (f_step != null && f_step.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_step", maxTerms));
		}

		if (f_tag_id != null && f_tag_id.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_tag_id", maxTerms));
		}

		if (f_user_id != null && f_user_id.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_user_id", maxTerms));
		}

		if (f_crm_id != null && f_crm_id.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_crm_id", maxTerms));
		}

		if (f_crea_userid != null && f_crea_userid.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_crea_userid", maxTerms));
		}

		if (f_business_id != null && f_business_id.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_business_id", maxTerms));
		}

		if (f_from != null && f_from.size() > maxTerms) {
			throw new RuntimeException(String.format(format, "f_from", maxTerms));
		}

		if (customFieldDate != null && customFieldDate.size() > 10) {
			throw new RuntimeException(String.format(format, "customFieldDate", 10));
		}

		if (customFieldText != null && customFieldText.size() > 10) {
			throw new RuntimeException(String.format(format, "customFieldText", 10));
		}

		// 检验时间
		checkTimeDto(f_modify_time, "f_modify_time");
		checkTimeDto(f_contact_time, "f_contact_time");
		checkTimeDto(f_create_time, "f_create_time");

		checkContactTime();

	}

	private void checkContactTime() {
		if(lastContactTime==null) {
			return;
		}
		String key = "lastContactTime";
		if(lastContactTime.getF_time()==null) {
			throw new RuntimeException(String.format("参数错误: %s 时间参数错误, lastContactTime = %s", key, lastContactTime));
		}
		if(lastContactTime.getF_type()==null || lastContactTime.getF_type().size()==0) {
			throw new RuntimeException(String.format("参数错误: %s 时间参数错误, lastContactTime = %s", key, lastContactTime));
		}
		// 验证时间
		checkTimeDto(lastContactTime.getF_time(), "lastContactTime");
		// 验证长度
		String format = "参数错误: %s.f_type 长度大于  %s";
		if (lastContactTime.getF_type().size() > 20) {
			throw new RuntimeException(String.format(format, key, 20));
		}

	}

	public void checkTimeDto(TimeDto dot, String key) {
		if (dot != null) {
			Long begin = dot.getBeginTime();
			Long end = dot.getBeginTime();
			if (begin == null || end == null) {
				throw new RuntimeException(String.format("参数错误: %s 时间参数错误, time = %s", key, dot));
			}

			if (begin > end) {
				throw new RuntimeException(String.format("参数错误: %s 时间参数错误, 开始时间大于结束时间，  time = %s", key, dot));
			}
		}
	}

}
