package com.ec.v2.entity.contactbook;


import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * CrmContactBook 联系人实体类
 *
 * @author : BorgXiao@126.com
 * @version : 1.0
 * @date :  2020-04-24 11:41
 **/
@Data
@NoArgsConstructor
public class CrmContactBook implements Serializable {

    private static final long serialVersionUID = -5524329834769455688L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 客户id
     */
    private Long crmId;

    /**
     * 企业id
     */
    private Long corpId;

    /**
     * 创建的用户id
     */
    private Long createUserId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 称呼
     */
    private String callName;

    /**
     * 职位
     */
    private String title;

    /**
     * 手机号码国家码
     */
    private String mobileCode;

    /**
     * 手机号码
     */
    private String mobile;

    /**
     * 电话号码国家码
     */
    private String phoneCode;

    /**
     * 电话
     */
    private String phone;

    /**
     * 电话号码分机号码
     */
    private String phoneExtension;

    /**
     * QQ
     */
    private String qq;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 微信
     */
    private String wechat;

    /**
     * 生日
     */
    private String birthday;

    /**
     * 农历生日
     */
    private String lunarBirthday;

    /**
     * 是否闰月生日 0/1
     */
    private Integer lunarLeap;

    /**
     * 备注
     */
    private String memo;

    /**
     * 客户性别：0：无，1：男，2：女
     */
    private Byte gender;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

}
