package com.ec.v2.common;

public enum BusinessIndexEnum {
	/***
	 * // 业务模块：1 电话联系统计 -> 业务指标：11 通话时长, 12 拨打次数 ,13 接通次数,14 接通率,15 平均通话时长,16 联系人数量
	 * 
	 * // 业务模块：2 客户数量统计 -> 业务指标：21 入库客户数, 22 流失客户数, 23 客户总数
	 * 
	 * // 业务模块：3 客户活跃统计 -> 业务指标：31 最近联系时间, 32 最近联系次数
	 * 
	 * // 业务模块：4 标签变化统计 -> 业务指标：41 标签新增量, 42 标签删除量, 43 标签净增量
	 * 
	 * // 业务模块：5 工作效率统计 -> 业务指标：501 联系客户数, 502 跟进记录数, 503 QQ, 504 短信，505 拜访, 506 邮件，
	 * 507 微信, 508 电话-拨打次数,509 电话-通话时长， 510 新增订单, 511 成交订单量, 512 成交金额，513 入库客户
	 * 
	 * // 业务模块：6 销售漏斗 -> 业务指标：61 按金额，62 按单量
	 * 
	 * // 业务模块：7 成交走势 -> 业务指标：71 成交金额,72 成交单量
	 */

	/**
	 * 电话相关指标
	 */
	BUSSINESS_MODEL_PHONE_CALLTIME(11, "通话时长"), BUSSINESS_MODEL_PHONE_CALLCOUNT(12, "拨打次数"),
	BUSSINESS_MODEL_PHONE_CONNECTCOUNT(13, "接通次数"), BUSSINESS_MODEL_PHONE_CALLPERCENT(14, "接通率"),
	BUSSINESS_MODEL_PHONE_TIMEAVERAGE(15, "平均通话时长"), BUSSINESS_MODEL_PHONE_CONTACT(16, "联系人数量"),

	/**
	 * 客户数量相关指标
	 */
	BUSSINESS_MODEL_CRM_QUANTITY_INSTORAGE(21, "入库客户数"),
	BUSSINESS_MODEL_CRM_QUANTITY_WASTAGE(22, "流失客户数"),
	BUSSINESS_MODEL_CRM_QUANTITY_TOTAL(23, "客户总数"),

	/**
	 * 活跃客户相关指标
	 */
	BUSSINESS_MODEL_CRM_ACTIVE_TIME(31, "最近联系时间"), BUSSINESS_MODEL_CRM_ACTIVE_COUNT(32, "最近联系次数"),

	/**
	 * 标签变化相关指标
	 */
	BUSSINESS_MODEL_TAG_INCREASE(41, "标签新增量"), BUSSINESS_MODEL_TAG_DECREASE(42, "标签删除量"),
	BUSSINESS_MODEL_TAG_NET_DECREASE(43, "标签净增量"),

	/**
	 * 工作效率相关指标
	 */
	BUSSINESS_MODEL_WORKEFFIC_CONTACT(501, "联系客户数"), BUSSINESS_MODEL_WORKEFFIC_FELLOW(502, "跟进记录数"),
	BUSSINESS_MODEL_WORKEFFIC_QQ(503, "QQ"), BUSSINESS_MODEL_WORKEFFIC_SMS(504, "短信"),
	BUSSINESS_MODEL_WORKEFFIC_VISIT(505, "拜访"), BUSSINESS_MODEL_WORKEFFIC_MAIL(506, "邮件"),
	BUSSINESS_MODEL_WORKEFFIC_WECHAT(507, "微信"), BUSSINESS_MODEL_WORKEFFIC_CALLCOUNT(508, "电话-拨打次数"),
	BUSSINESS_MODEL_WORKEFFIC_CALLTIME(509, "电话-通话时长"), BUSSINESS_MODEL_WORKEFFIC_ORDER_NEW(510, "新增订单"),
	BUSSINESS_MODEL_WORKEFFIC_PURCHASE_ORDER(511, "成交单量"), BUSSINESS_MODEL_WORKEFFIC_PURCHASE_MONEY(512, "成交金额"),
	BUSSINESS_MODEL_WORKEFFIC_CRM_INSTORAGE(513, "入库客户"),

	/**
	 * 销售漏斗相关指标
	 */
	BUSSINESS_MODEL_SALES_FUNNEL_MONEY(61, "按金额"), BUSSINESS_MODEL_SALES_FUNNEL_ORDER(62, "按单量"),

	/**
	 * 成交走势相关指标
	 */
	BUSSINESS_MODEL_PURCHASE_TREND_MONEY(71, "成交金额"), BUSSINESS_MODEL_PURCHASE_TREND_ORDER(72, "成交单量");

	private Integer index;
	private String value;

	BusinessIndexEnum(int index, String value) {
		this.index = index;
		this.value = value;
	}

	public int getIndex() {
		return index;
	}

	public String getValue() {
		return value;
	}

	public static String getValueByIndex(int index) {
		String value = "未知";
		BusinessIndexEnum[] all = BusinessIndexEnum.values();
		for (int k = 0; k < all.length; k++) {
			BusinessIndexEnum t = all[k];
			if (index == t.getIndex()) {
				return t.getValue();
			}
		}
		return value;
	}
}
