/*
 * Decompiled with CFR 0.152.
 */
package com.wordplat.uikit.service;

import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.wordplat.uikit.splash.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.concurrent.Executors;

public class DownloadAppService
extends Service {
    private static final String TAG = "DownloadService";
    private static final int BUFFER_SIZE = 10240;
    private static int NOTIFICATION_ID = 0;
    private NotificationManager notifyManager;
    private NotificationCompat.Builder builder;
    private static final int MSG_DOWNLOAD_START = 1;
    private static final int MSG_DOWNLOAD_UPDATE = 2;
    private static final int MSG_DOWNLOAD_END = 3;
    private static final int MSG_DOWNLOAD_FAILED = 4;
    private final Handler downloadHandler = new DownloadHandler(this);

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        ExecutorService.INSTANCE.shutdown();
        this.downloadHandler.removeCallbacksAndMessages(null);
        if (this.notifyManager != null) {
            this.notifyManager.cancelAll();
        }
    }

    public void onTrimMemory(int level) {
    }

    public void onDestroy() {
        super.onDestroy();
        ExecutorService.INSTANCE.shutdown();
        this.downloadHandler.removeCallbacksAndMessages(null);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null) {
            this.onHandleIntent(intent);
        }
        return super.onStartCommand(intent, flags, startId);
    }

    void onHandleIntent(Intent intent) {
        this.notifyManager = (NotificationManager)this.getSystemService("notification");
        this.builder = new NotificationCompat.Builder((Context)this);
        int iconResId = intent.getIntExtra("iconResId", 0);
        String appName = intent.getStringExtra("appName");
        String appUrl = intent.getStringExtra("appUrl");
        int notificationId = intent.getIntExtra("notificationId", 0);
        final NotifyBean notifyBean = new NotifyBean();
        notifyBean.setIconResId(iconResId);
        notifyBean.setAppName(appName);
        notifyBean.setAppUrl(appUrl);
        notifyBean.setNotificationId(notificationId);
        this.builder.setContentTitle((CharSequence)appName).setContentText((CharSequence)this.getResources().getString(R.string.splash_download_ready)).setSmallIcon(iconResId);
        this.notifyManager.notify(notifyBean.getNotificationId(), this.builder.build());
        Log.i((String)TAG, (String)("##d onHandleIntent: appName = " + appName + ", appUrl = " + appUrl + ", notificationId = " + notificationId));
        ExecutorService.INSTANCE.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String appUrl = notifyBean.getAppUrl();
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    URL url = new URL(appUrl);
                    HttpURLConnection urlConnection = DownloadAppService.this.openUrlConnection(url);
                    String location = urlConnection.getHeaderField("Location");
                    URL newUrl = !TextUtils.isEmpty((CharSequence)location) && !location.equals(appUrl) ? new URL(location) : urlConnection.getURL();
                    HttpURLConnection newUrlConnection = DownloadAppService.this.openUrlConnection(newUrl);
                    newUrlConnection.connect();
                    long bytetotal = newUrlConnection.getContentLength();
                    long bytesum = 0L;
                    int byteread = 0;
                    in = newUrlConnection.getInputStream();
                    File dir = new File("/sdcard/Download");
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    MessageDigest md5 = MessageDigest.getInstance("MD5");
                    byte[] bytes = md5.digest(appUrl.getBytes("utf-8"));
                    String hexString = "";
                    for (byte b : bytes) {
                        int temp = b & 0xFF;
                        hexString = temp < 16 && temp >= 0 ? hexString + "0" + Integer.toHexString(temp) : hexString + Integer.toHexString(temp);
                    }
                    String apkName = hexString + ".apk";
                    File apkFile = new File(dir, apkName);
                    notifyBean.setApkFile(apkFile);
                    out = new FileOutputStream(apkFile);
                    byte[] buffer = new byte[10240];
                    int oldProgress = 0;
                    while ((byteread = in.read(buffer)) != -1) {
                        out.write(buffer, 0, byteread);
                        int progress = (int)((bytesum += (long)byteread) * 100L / bytetotal);
                        if (progress != oldProgress) {
                            notifyBean.setProgress(progress);
                            DownloadAppService.this.downloadHandler.obtainMessage(2, (Object)notifyBean).sendToTarget();
                        }
                        oldProgress = progress;
                    }
                    DownloadAppService.this.downloadHandler.obtainMessage(3, (Object)notifyBean).sendToTarget();
                }
                catch (Exception e) {
                    Log.e((String)DownloadAppService.TAG, (String)"##d download apk file error");
                    e.printStackTrace();
                    DownloadAppService.this.downloadHandler.obtainMessage(4, (Object)notifyBean).sendToTarget();
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        });
    }

    private HttpURLConnection openUrlConnection(URL url) throws IOException {
        Log.i((String)TAG, (String)("##d openUrlConnection: " + url.toString()));
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.setDoOutput(false);
        urlConnection.setConnectTimeout(10000);
        urlConnection.setReadTimeout(10000);
        urlConnection.setRequestProperty("Connection", "Keep-Alive");
        urlConnection.setRequestProperty("Charset", "UTF-8");
        urlConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        return urlConnection;
    }

    private void updateFailed(NotifyBean notifyBean) {
        this.builder.setContentTitle((CharSequence)notifyBean.getAppName()).setContentText((CharSequence)this.getResources().getString(R.string.splash_download_failed)).setProgress(100, 0, false).setSmallIcon(notifyBean.getIconResId());
        this.notifyManager.notify(notifyBean.getNotificationId(), this.builder.build());
    }

    private void updateProgress(NotifyBean notifyBean) {
        this.builder.setContentTitle((CharSequence)notifyBean.getAppName()).setContentText((CharSequence)(this.getResources().getString(R.string.splash_downloading) + notifyBean.getProgress() + "%")).setProgress(100, notifyBean.getProgress(), false).setSmallIcon(notifyBean.getIconResId());
        PendingIntent pendingintent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent(), (int)0x10000000);
        this.builder.setContentIntent(pendingintent);
        this.notifyManager.notify(notifyBean.getNotificationId(), this.builder.build());
    }

    private void installAPk(File apkFile) {
        Intent intent = new Intent("android.intent.action.VIEW");
        try {
            String[] command = new String[]{"chmod", "777", apkFile.toString()};
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.start();
        }
        catch (IOException command) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Uri apkUri = FileProvider.getUriForFile((Context)this.getApplicationContext(), (String)(this.getApplicationContext().getPackageName() + ".provider"), (File)apkFile);
            intent.setDataAndType(apkUri, "application/vnd.android.package-archive");
            intent.addFlags(1);
        } else {
            intent.setDataAndType(Uri.fromFile((File)apkFile), "application/vnd.android.package-archive");
        }
        intent.addFlags(0x10000000);
        this.startActivity(intent);
    }

    public static Intent createIntent(Context context, int iconResId, String appUrl, String appName) {
        Intent intent = new Intent(context, DownloadAppService.class);
        intent.putExtra("iconResId", iconResId);
        intent.putExtra("appName", appName);
        intent.putExtra("appUrl", appUrl);
        intent.putExtra("notificationId", NOTIFICATION_ID++);
        return intent;
    }

    private static enum ExecutorService {
        INSTANCE;

        private final java.util.concurrent.ExecutorService executorService = Executors.newFixedThreadPool(5);

        public void shutdown() {
            if (this.executorService != null) {
                this.executorService.shutdown();
            }
        }

        public void execute(Runnable runnable) {
            this.executorService.execute(runnable);
        }
    }

    private static class DownloadHandler
    extends Handler {
        private final WeakReference<DownloadAppService> reference;

        public DownloadHandler(DownloadAppService service) {
            this.reference = new WeakReference<DownloadAppService>(service);
        }

        public void handleMessage(Message msg) {
            NotifyBean notifyBean = (NotifyBean)msg.obj;
            DownloadAppService service = (DownloadAppService)((Object)this.reference.get());
            if (service == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    break;
                }
                case 2: {
                    service.updateProgress(notifyBean);
                    break;
                }
                case 3: {
                    File apkFile = notifyBean.getApkFile();
                    service.installAPk(apkFile);
                    service.notifyManager.cancel(notifyBean.getNotificationId());
                    break;
                }
                case 4: {
                    service.updateFailed(notifyBean);
                }
            }
        }
    }

    private static class NotifyBean {
        private int iconResId;
        private String appName;
        private String appUrl;
        private int notificationId;
        private File apkFile;
        private int progress;

        private NotifyBean() {
        }

        public int getIconResId() {
            return this.iconResId;
        }

        public void setIconResId(int iconResId) {
            this.iconResId = iconResId;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getAppUrl() {
            return this.appUrl;
        }

        public void setAppUrl(String appUrl) {
            this.appUrl = appUrl;
        }

        public int getNotificationId() {
            return this.notificationId;
        }

        public void setNotificationId(int notificationId) {
            this.notificationId = notificationId;
        }

        public File getApkFile() {
            return this.apkFile;
        }

        public void setApkFile(File apkFile) {
            this.apkFile = apkFile;
        }

        public int getProgress() {
            return this.progress;
        }

        public void setProgress(int progress) {
            this.progress = progress;
        }
    }
}

