/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.AdmRegistration;
import com.windowsazure.messaging.AdmTemplateRegistration;
import com.windowsazure.messaging.AppleRegistration;
import com.windowsazure.messaging.AppleTemplateRegistration;
import com.windowsazure.messaging.BaiduRegistration;
import com.windowsazure.messaging.BaiduTemplateRegistration;
import com.windowsazure.messaging.CollectionResult;
import com.windowsazure.messaging.FcmRegistration;
import com.windowsazure.messaging.FcmTemplateRegistration;
import com.windowsazure.messaging.GcmRegistration;
import com.windowsazure.messaging.GcmTemplateRegistration;
import com.windowsazure.messaging.MpnsRegistration;
import com.windowsazure.messaging.MpnsTemplateRegistration;
import com.windowsazure.messaging.WindowsRegistration;
import com.windowsazure.messaging.WindowsTemplateRegistration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class Registration
implements Cloneable {
    protected String registrationId;
    protected Set<String> tags = new HashSet<String>();
    protected String etag;
    protected Date expirationTime;
    private static final ThreadLocal<Digester> singleRegParser = ThreadLocal.withInitial(() -> {
        Digester instance = new Digester();
        Registration.addRegistrationRules(instance);
        return instance;
    });
    private static final ThreadLocal<Digester> multiRegParser = ThreadLocal.withInitial(() -> {
        Digester instance = new Digester();
        Registration.addRegistrationRules(instance);
        Registration.addCollectionRules(instance);
        return instance;
    });

    public Registration() {
    }

    public Registration clone() {
        try {
            return (Registration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Registration(String registrationId) {
        this.registrationId = registrationId;
    }

    public Registration(Set<String> tags) {
        this.tags = tags;
    }

    public abstract String getXml();

    public String getRegistrationId() {
        return this.registrationId;
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public void setTagsFromString(String string) {
        String[] tagsArray;
        this.tags = new HashSet<String>();
        for (String s : tagsArray = string.split(",")) {
            this.tags.add(s.trim());
        }
    }

    protected String getTagsXml() {
        StringBuilder buf = new StringBuilder();
        if (!this.tags.isEmpty()) {
            buf.append("<Tags>");
            Iterator<String> i = this.tags.iterator();
            while (i.hasNext()) {
                buf.append(i.next());
                if (!i.hasNext()) continue;
                buf.append(",");
            }
            buf.append("</Tags>");
        }
        return buf.toString();
    }

    public Date getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(Date expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setExpirationTimeFromString(String expirationTimeString) {
        this.expirationTime = DatatypeConverter.parseDateTime((String)expirationTimeString).getTime();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.etag == null ? 0 : this.etag.hashCode());
        result = 31 * result + (this.expirationTime == null ? 0 : this.expirationTime.hashCode());
        result = 31 * result + (this.registrationId == null ? 0 : this.registrationId.hashCode());
        result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Registration other = (Registration)obj;
        if (this.etag == null ? other.etag != null : !this.etag.equals(other.etag)) {
            return false;
        }
        if (this.expirationTime == null ? other.expirationTime != null : !this.expirationTime.equals(other.expirationTime)) {
            return false;
        }
        if (this.registrationId == null ? other.registrationId != null : !this.registrationId.equals(other.registrationId)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public static Registration parse(InputStream content) throws IOException, SAXException {
        return (Registration)singleRegParser.get().parse(content);
    }

    private static void addRegistrationRules(Digester digester) {
        digester.addFactoryCreate("*/RegistrationDescription", (ObjectCreationFactory)new RegistrationCreationFactory());
        digester.addObjectCreate("*/WindowsRegistrationDescription", WindowsRegistration.class);
        digester.addObjectCreate("*/WindowsTemplateRegistrationDescription", WindowsTemplateRegistration.class);
        digester.addObjectCreate("*/AppleRegistrationDescription", AppleRegistration.class);
        digester.addObjectCreate("*/AppleTemplateRegistrationDescription", AppleTemplateRegistration.class);
        digester.addObjectCreate("*/GcmRegistrationDescription", GcmRegistration.class);
        digester.addObjectCreate("*/GcmTemplateRegistrationDescription", GcmTemplateRegistration.class);
        digester.addObjectCreate("*/FcmRegistrationDescription", FcmRegistration.class);
        digester.addObjectCreate("*/FcmTemplateRegistrationDescription", FcmTemplateRegistration.class);
        digester.addObjectCreate("*/MpnsRegistrationDescription", MpnsRegistration.class);
        digester.addObjectCreate("*/MpnsTemplateRegistrationDescription", MpnsTemplateRegistration.class);
        digester.addObjectCreate("*/AdmRegistrationDescription", AdmRegistration.class);
        digester.addObjectCreate("*/AdmTemplateRegistrationDescription", AdmTemplateRegistration.class);
        digester.addObjectCreate("*/BaiduRegistrationDescription", BaiduRegistration.class);
        digester.addObjectCreate("*/BaiduTemplateRegistrationDescription", BaiduTemplateRegistration.class);
        digester.addCallMethod("*/RegistrationId", "setRegistrationId", 1);
        digester.addCallParam("*/RegistrationId", 0);
        digester.addCallMethod("*/ETag", "setEtag", 1);
        digester.addCallParam("*/ETag", 0);
        digester.addCallMethod("*/ChannelUri", "setChannelUri", 1);
        digester.addCallParam("*/ChannelUri", 0);
        digester.addCallMethod("*/DeviceToken", "setDeviceToken", 1);
        digester.addCallParam("*/DeviceToken", 0);
        digester.addCallMethod("*/GcmRegistrationId", "setGcmRegistrationId", 1);
        digester.addCallParam("*/GcmRegistrationId", 0);
        digester.addCallMethod("*/FcmRegistrationId", "setFcmRegistrationId", 1);
        digester.addCallParam("*/FcmRegistrationId", 0);
        digester.addCallMethod("*/Tags", "setTagsFromString", 1);
        digester.addCallParam("*/Tags", 0);
        digester.addCallMethod("*/BodyTemplate", "setBodyTemplate", 1);
        digester.addCallParam("*/BodyTemplate", 0);
        digester.addCallMethod("*/WnsHeader", "addHeader", 2);
        digester.addCallParam("*/WnsHeader/Header", 0);
        digester.addCallParam("*/WnsHeader/Value", 1);
        digester.addCallMethod("*/MpnsHeader", "addHeader", 2);
        digester.addCallParam("*/MpnsHeader/Header", 0);
        digester.addCallParam("*/MpnsHeader/Value", 1);
        digester.addCallMethod("*/Expiry", "setExpiry", 1);
        digester.addCallParam("*/Expiry", 0);
        digester.addCallMethod("*/ExpirationTime", "setExpirationTimeFromString", 1);
        digester.addCallParam("*/ExpirationTime", 0);
        digester.addCallMethod("*/AdmRegistrationId", "setAdmRegistrationId", 1);
        digester.addCallParam("*/AdmRegistrationId", 0);
        digester.addCallMethod("*/BaiduUserId", "setBaiduUserId", 1);
        digester.addCallParam("*/BaiduUserId", 0);
        digester.addCallMethod("*/BaiduChannelId", "setBaiduChannelId", 1);
        digester.addCallParam("*/BaiduChannelId", 0);
    }

    public static CollectionResult parseRegistrations(InputStream content) throws IOException, SAXException {
        return (CollectionResult)multiRegParser.get().parse(content);
    }

    private static void addCollectionRules(Digester digester) {
        digester.addObjectCreate("feed", CollectionResult.class);
        digester.addSetNext("*/RegistrationDescription", "addRegistration");
        digester.addSetNext("*/WindowsRegistrationDescription", "addRegistration");
        digester.addSetNext("*/WindowsTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/AppleRegistrationDescription", "addRegistration");
        digester.addSetNext("*/AppleTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/GcmRegistrationDescription", "addRegistration");
        digester.addSetNext("*/GcmTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/FcmRegistrationDescription", "addRegistration");
        digester.addSetNext("*/FcmTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/MpnsRegistrationDescription", "addRegistration");
        digester.addSetNext("*/MpnsTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/AdmRegistrationDescription", "addRegistration");
        digester.addSetNext("*/AdmTemplateRegistrationDescription", "addRegistration");
        digester.addSetNext("*/BaiduRegistrationDescription", "addRegistration");
        digester.addSetNext("*/BaiduTemplateRegistrationDescription", "addRegistration");
    }

    public static class RegistrationCreationFactory
    implements ObjectCreationFactory<Object> {
        private Digester digester;

        public Object createObject(Attributes attributes) {
            if ("WindowsRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new WindowsRegistration();
            }
            if ("WindowsTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new WindowsTemplateRegistration();
            }
            if ("AppleRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new AppleRegistration();
            }
            if ("AppleTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new AppleTemplateRegistration();
            }
            if ("GcmRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new GcmRegistration();
            }
            if ("GcmTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new GcmTemplateRegistration();
            }
            if ("FcmRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new FcmRegistration();
            }
            if ("FcmTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new FcmTemplateRegistration();
            }
            if ("MpnsRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new MpnsRegistration();
            }
            if ("MpnsTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new MpnsTemplateRegistration();
            }
            if ("AdmRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new AdmRegistration();
            }
            if ("AdmTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new AdmTemplateRegistration();
            }
            if ("BaiduRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new BaiduRegistration();
            }
            if ("BaiduTemplateRegistrationDescription".equals(attributes.getValue("i:type"))) {
                return new BaiduTemplateRegistration();
            }
            throw new UnsupportedOperationException("unknown type: " + attributes.getValue("i:type"));
        }

        public Digester getDigester() {
            return this.digester;
        }

        public void setDigester(Digester digester) {
            this.digester = digester;
        }
    }
}

