/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import java.time.Duration;
import java.util.Optional;

public class NotificationHubsException
extends Exception {
    private final int httpStatusCode;
    private final boolean isTransient;
    private Duration retryAfter;

    public NotificationHubsException(String message, int httpStatusCode, boolean isTransient) {
        super(message);
        this.httpStatusCode = httpStatusCode;
        this.isTransient = isTransient;
    }

    public NotificationHubsException(String message, int httpStatusCode, boolean isTransient, Duration retryAfter) {
        this(message, httpStatusCode, isTransient);
        this.retryAfter = retryAfter;
    }

    public int httpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public Optional<Duration> retryAfter() {
        return Optional.ofNullable(this.retryAfter);
    }
}

