/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.HttpClientManager;
import com.windowsazure.messaging.NamespaceManagerClient;
import com.windowsazure.messaging.NotificationHubDescription;
import com.windowsazure.messaging.NotificationHubsException;
import com.windowsazure.messaging.NotificationHubsExceptionFactory;
import com.windowsazure.messaging.SdkGlobalSettings;
import com.windowsazure.messaging.SyncCallback;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class NamespaceManager
implements NamespaceManagerClient {
    private static final String IF_MATCH_HEADER_NAME = "If-Match";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String HUBS_COLLECTION_PATH = "$Resources/NotificationHubs/";
    private static final String API_VERSION = "?api-version=2014-09";
    private static final String SKIP_TOP_PARAM = "&$skip=0&$top=2147483647";
    private String endpoint;
    private String SasKeyName;
    private String SasKeyValue;

    public NamespaceManager(String connectionString) {
        String[] parts = connectionString.split(";");
        if (parts.length != 3) {
            throw new RuntimeException("Error parsing connection string: " + connectionString);
        }
        for (String part : parts) {
            if (part.startsWith("Endpoint")) {
                this.endpoint = "https" + part.substring(11);
                continue;
            }
            if (part.startsWith("SharedAccessKeyName")) {
                this.SasKeyName = part.substring(20);
                continue;
            }
            if (!part.startsWith("SharedAccessKey")) continue;
            this.SasKeyValue = part.substring(16);
        }
    }

    @Override
    public void getNotificationHubAsync(String hubPath, final FutureCallback<NotificationHubDescription> callback) {
        try {
            URI uri = new URI(this.endpoint + hubPath + API_VERSION);
            final HttpGet get = new HttpGet(uri);
            get.setHeader(AUTHORIZATION_HEADER_NAME, this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)NotificationHubsExceptionFactory.createNotificationHubException(response, httpStatusCode));
                            return;
                        }
                        callback.completed((Object)NotificationHubDescription.parseOne(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NotificationHubDescription getNotificationHub(String hubPath) throws NotificationHubsException {
        SyncCallback<NotificationHubDescription> callback = new SyncCallback<NotificationHubDescription>();
        this.getNotificationHubAsync(hubPath, callback);
        return callback.getResult();
    }

    @Override
    public void getNotificationHubsAsync(final FutureCallback<List<NotificationHubDescription>> callback) {
        try {
            URI uri = new URI(this.endpoint + HUBS_COLLECTION_PATH + API_VERSION + SKIP_TOP_PARAM);
            final HttpGet get = new HttpGet(uri);
            get.setHeader(AUTHORIZATION_HEADER_NAME, this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)get, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200) {
                            callback.failed((Exception)NotificationHubsExceptionFactory.createNotificationHubException(response, httpStatusCode));
                            return;
                        }
                        callback.completed(NotificationHubDescription.parseCollection(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        get.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    get.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    get.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<NotificationHubDescription> getNotificationHubs() throws NotificationHubsException {
        SyncCallback<List<NotificationHubDescription>> callback = new SyncCallback<List<NotificationHubDescription>>();
        this.getNotificationHubsAsync(callback);
        return callback.getResult();
    }

    @Override
    public void createNotificationHubAsync(NotificationHubDescription hubDescription, FutureCallback<NotificationHubDescription> callback) {
        this.createOrUpdateNotificationHubAsync(hubDescription, false, callback);
    }

    @Override
    public NotificationHubDescription createNotificationHub(NotificationHubDescription hubDescription) throws NotificationHubsException {
        SyncCallback<NotificationHubDescription> callback = new SyncCallback<NotificationHubDescription>();
        this.createNotificationHubAsync(hubDescription, callback);
        return callback.getResult();
    }

    @Override
    public void updateNotificationHubAsync(NotificationHubDescription hubDescription, FutureCallback<NotificationHubDescription> callback) {
        this.createOrUpdateNotificationHubAsync(hubDescription, true, callback);
    }

    @Override
    public NotificationHubDescription updateNotificationHub(NotificationHubDescription hubDescription) throws NotificationHubsException {
        SyncCallback<NotificationHubDescription> callback = new SyncCallback<NotificationHubDescription>();
        this.updateNotificationHubAsync(hubDescription, callback);
        return callback.getResult();
    }

    private void createOrUpdateNotificationHubAsync(NotificationHubDescription hubDescription, final boolean isUpdate, final FutureCallback<NotificationHubDescription> callback) {
        try {
            URI uri = new URI(this.endpoint + hubDescription.getPath() + API_VERSION);
            final HttpPut put = new HttpPut(uri);
            put.setHeader(AUTHORIZATION_HEADER_NAME, this.generateSasToken(uri));
            if (isUpdate) {
                put.setHeader(IF_MATCH_HEADER_NAME, "*");
            }
            StringEntity entity = new StringEntity(hubDescription.getXml(), ContentType.APPLICATION_ATOM_XML);
            entity.setContentEncoding("utf-8");
            put.setEntity((HttpEntity)entity);
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)put, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != (isUpdate ? 200 : 201)) {
                            callback.failed((Exception)NotificationHubsExceptionFactory.createNotificationHubException(response, httpStatusCode));
                            return;
                        }
                        callback.completed((Object)NotificationHubDescription.parseOne(response.getEntity().getContent()));
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        put.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    put.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    put.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteNotificationHubAsync(String hubPath, final FutureCallback<Object> callback) {
        try {
            URI uri = new URI(this.endpoint + hubPath + API_VERSION);
            final HttpDelete delete = new HttpDelete(uri);
            delete.setHeader(AUTHORIZATION_HEADER_NAME, this.generateSasToken(uri));
            HttpClientManager.getHttpAsyncClient().execute((HttpUriRequest)delete, (FutureCallback)new FutureCallback<HttpResponse>(){

                public void completed(HttpResponse response) {
                    try {
                        int httpStatusCode = response.getStatusLine().getStatusCode();
                        if (httpStatusCode != 200 && httpStatusCode != 404) {
                            callback.failed((Exception)NotificationHubsExceptionFactory.createNotificationHubException(response, httpStatusCode));
                            return;
                        }
                        callback.completed(null);
                    }
                    catch (Exception e) {
                        callback.failed(e);
                    }
                    finally {
                        delete.releaseConnection();
                    }
                }

                public void failed(Exception ex) {
                    delete.releaseConnection();
                    callback.failed(ex);
                }

                public void cancelled() {
                    delete.releaseConnection();
                    callback.cancelled();
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteNotificationHub(String hubPath) throws NotificationHubsException {
        SyncCallback<Object> callback = new SyncCallback<Object>();
        this.deleteNotificationHubAsync(hubPath, callback);
        callback.getResult();
    }

    private String generateSasToken(URI uri) {
        try {
            String targetUri = URLEncoder.encode(uri.toString().toLowerCase(), "UTF-8").toLowerCase();
            long expiresOnDate = System.currentTimeMillis();
            long expires = (expiresOnDate += (long)(SdkGlobalSettings.getAuthorizationTokenExpirationInMinutes() * 60 * 1000)) / 1000L;
            String toSign = targetUri + "\n" + expires;
            byte[] keyBytes = this.SasKeyValue.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec signingKey = new SecretKeySpec(keyBytes, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(toSign.getBytes(StandardCharsets.UTF_8));
            String signature = URLEncoder.encode(Base64.encodeBase64String((byte[])rawHmac), "UTF-8");
            return "SharedAccessSignature sr=" + targetUri + "&sig=" + signature + "&se=" + expires + "&skn=" + this.SasKeyName;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

