/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.Registration;
import java.net.URI;
import java.net.URISyntaxException;

public class MpnsRegistration
extends Registration {
    private static final String MPNS_NATIVE_REGISTRATION1 = "<?xml version=\"1.0\" encoding=\"utf-8\"?><entry xmlns=\"http://www.w3.org/2005/Atom\"><content type=\"application/xml\"><MpnsRegistrationDescription xmlns:i=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns=\"http://schemas.microsoft.com/netservices/2010/10/servicebus/connect\">";
    private static final String MPNS_NATIVE_REGISTRATION2 = "<ChannelUri>";
    private static final String MPNS_NATIVE_REGISTRATION3 = "</ChannelUri></MpnsRegistrationDescription></content></entry>";
    protected URI channelUri;

    public MpnsRegistration() {
    }

    public MpnsRegistration(URI channelUri) {
        this.channelUri = channelUri;
    }

    public MpnsRegistration(String registrationId, URI channelUri) {
        super(registrationId);
        this.channelUri = channelUri;
    }

    public URI getChannelUri() {
        return this.channelUri;
    }

    public void setChannelUri(String channelUri) {
        try {
            this.channelUri = new URI(channelUri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(channelUri);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.channelUri == null ? 0 : this.channelUri.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MpnsRegistration other = (MpnsRegistration)obj;
        return !(this.channelUri == null ? other.channelUri != null : !this.channelUri.equals(other.channelUri));
    }

    @Override
    public String getXml() {
        return MPNS_NATIVE_REGISTRATION1 + this.getTagsXml() + MPNS_NATIVE_REGISTRATION2 + this.channelUri.toString() + MPNS_NATIVE_REGISTRATION3;
    }
}

