/*
 * Decompiled with CFR 0.152.
 */
package com.windowsazure.messaging;

import com.windowsazure.messaging.PnsCredential;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;

public final class ApnsCredential
extends PnsCredential {
    public static final String PROD_ENDPOINT = "gateway.push.apple.com";
    public static final String SANDBOX_ENDPOINT = "gateway.sandbox.push.apple.com";
    public static final String APNS2_PROD_ENDPOINT = "https://api.push.apple.com:443/3/device";
    public static final String APNS2_DEV_ENDPOINT = "https://api.development.push.apple.com:443/3/device";
    private String endpoint;
    private String apnsCertificate;
    private String certificateKey;
    private String thumbprint;
    private String token;
    private String keyId;
    private String appName;
    private String appId;

    public ApnsCredential() {
        this(null, null);
    }

    public ApnsCredential(String endpoint) {
        this(null, null, endpoint);
    }

    public ApnsCredential(String apnsCertificate, String certificateKey) {
        this(apnsCertificate, certificateKey, PROD_ENDPOINT);
    }

    public ApnsCredential(String apnsCertificate, String certificateKey, String endpoint) {
        this.apnsCertificate = apnsCertificate;
        this.certificateKey = certificateKey;
        this.endpoint = endpoint;
    }

    public ApnsCredential(String token, String keyId, String appId, String appName) {
        this(token, keyId, appId, appName, PROD_ENDPOINT);
    }

    public ApnsCredential(String token, String keyId, String appId, String appName, String endpoint) {
        this.token = token;
        this.keyId = keyId;
        this.appId = appId;
        this.appName = appName;
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getApnsCertificate() {
        return this.apnsCertificate;
    }

    public void setApnsCertificate(String apnsCertificate) {
        this.apnsCertificate = apnsCertificate;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String value) {
        this.thumbprint = value;
    }

    public String getCertificateKey() {
        return this.certificateKey;
    }

    public void setCertificateKey(String certificateKey) {
        this.certificateKey = certificateKey;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public List<AbstractMap.SimpleEntry<String, String>> getProperties() {
        ArrayList<AbstractMap.SimpleEntry<String, String>> result = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        result.add(new AbstractMap.SimpleEntry<String, String>("Endpoint", this.getEndpoint()));
        result.add(new AbstractMap.SimpleEntry<String, String>("ApnsCertificate", this.getApnsCertificate()));
        result.add(new AbstractMap.SimpleEntry<String, String>("CertificateKey", this.getCertificateKey()));
        result.add(new AbstractMap.SimpleEntry<String, String>("Thumbprint", this.getThumbprint()));
        result.add(new AbstractMap.SimpleEntry<String, String>("Token", this.getToken()));
        result.add(new AbstractMap.SimpleEntry<String, String>("KeyId", this.getKeyId()));
        result.add(new AbstractMap.SimpleEntry<String, String>("AppName", this.getAppName()));
        result.add(new AbstractMap.SimpleEntry<String, String>("AppId", this.getAppId()));
        return result;
    }

    @Override
    public String getRootTagName() {
        return "ApnsCredential";
    }
}

