/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.interactive.InteractiveState;
import com.amazon.identity.auth.device.interactive.InteractiveStateFragment;
import com.amazon.identity.auth.device.interactive.RequestSource;
import com.amazon.identity.auth.device.interactive.WorkflowSupportFragment;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.lang.ref.WeakReference;

public final class RequestSourceFragmentActivityWrapper
implements RequestSource {
    private static final String LOG_TAG = RequestSourceFragmentActivityWrapper.class.getName();
    private final WeakReference<FragmentActivity> activityReference;

    public RequestSourceFragmentActivityWrapper(FragmentActivity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must be non-null");
        }
        this.activityReference = new WeakReference<FragmentActivity>(activity);
    }

    public void onStartRequest(InteractiveRequestRecord request) {
        InteractiveState state = this.getInteractiveState();
        if (state != null) {
            state.onRequestStart(request);
        }
    }

    public InteractiveState getInteractiveState() {
        FragmentActivity activity = (FragmentActivity)this.activityReference.get();
        if (activity != null) {
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            try {
                InteractiveStateFragment stateFragment = (InteractiveStateFragment)fragmentManager.findFragmentByTag(InteractiveStateFragment.TAG_ID);
                if (stateFragment == null) {
                    WorkflowSupportFragment fragment = new WorkflowSupportFragment();
                    fragmentManager.beginTransaction().add((Fragment)fragment, InteractiveStateFragment.TAG_ID).commit();
                    stateFragment = fragment;
                }
                return stateFragment.getState();
            }
            catch (ClassCastException e) {
                MAPLog.e(LOG_TAG, "Found an invalid fragment looking for fragment with tag " + InteractiveStateFragment.TAG_ID + ". Please use a different fragment tag.", e);
            }
        } else {
            MAPLog.e(LOG_TAG, "Failed to get InteractiveState on a garbage-collected FragmentActivity");
        }
        return null;
    }

    public Object getBackingObject() {
        return this.activityReference.get();
    }

    public Context getContext() {
        return (Context)this.activityReference.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.activityReference == null || this.activityReference.get() == null ? 0 : ((FragmentActivity)this.activityReference.get()).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestSourceFragmentActivityWrapper other = (RequestSourceFragmentActivityWrapper)obj;
        if (this.activityReference == null) {
            if (other.activityReference != null) {
                return false;
            }
        } else {
            if (other.activityReference == null) {
                return false;
            }
            if (this.activityReference.get() == null ? other.activityReference.get() != null : !((FragmentActivity)this.activityReference.get()).equals(other.activityReference.get())) {
                return false;
            }
        }
        return true;
    }
}

