/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.interactive;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.api.workflow.ListenerNotFoundException;
import com.amazon.identity.auth.device.api.workflow.RequestContext;
import com.amazon.identity.auth.device.interactive.InteractiveAPI;
import com.amazon.identity.auth.device.interactive.InteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.workflow.WorkflowCancellation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractiveRequest<T extends InteractiveListener<S, U, V>, S, U, V>
implements InteractiveAPI,
InteractiveListener<S, U, V> {
    private RequestContext requestContext;

    public InteractiveRequest(RequestContext requestContext) {
        this.setRequestContext(requestContext);
    }

    public abstract Class<T> getListenerClass();

    public Context getContext() {
        return this.requestContext.getContext();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        if (requestContext == null) {
            throw new IllegalArgumentException("requestContext must be non-null");
        }
        this.requestContext = requestContext;
    }

    public Bundle getRequestExtras() {
        return null;
    }

    public void assertListenerPresent() throws ListenerNotFoundException {
        this.requestContext.assertListenerPresent(this);
    }

    @Override
    public void onSuccess(S result) {
        this.getAggregateListener().onSuccess(result);
    }

    @Override
    public void onCancel(U cancellation) {
        this.getAggregateListener().onCancel(cancellation);
    }

    @Override
    public void onError(V error) {
        this.getAggregateListener().onError(error);
    }

    @Override
    public void onRequestCompletion(Context context, InteractiveRequestRecord request, Uri uri) {
        this.getAggregateListener().onRequestCompletion(context, request, uri);
    }

    @Override
    public void onRequestError(Context context, InteractiveRequestRecord request, Exception e) {
        this.getAggregateListener().onRequestError(context, request, e);
    }

    @Override
    public void onRequestCancel(Context context, InteractiveRequestRecord request, WorkflowCancellation cancellation) {
        this.getAggregateListener().onRequestCancel(context, request, cancellation);
    }

    private InteractiveListener<S, U, V> getAggregateListener() {
        return this.requestContext.getAggregateListener(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Builder<W extends InteractiveRequest<?, ?, ?, ?>> {
        protected RequestContext requestContext;

        public Builder(RequestContext requestContext) {
            if (requestContext == null) {
                throw new IllegalArgumentException("A RequestContext is necessary for making interactive requests");
            }
            this.requestContext = requestContext;
        }

        public abstract W build();
    }
}

