/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.net.Uri;
import android.text.TextUtils;
import com.amazon.identity.auth.device.AuthError;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseUri {
    public static final String STATE_PARAMETER_NAME = "state";
    private final Uri uri;

    public ResponseUri(Uri uri) {
        this.uri = uri;
    }

    public Map<String, String> getStateValues() throws AuthError {
        String[] attributes;
        String state = this.uri.getQueryParameter(STATE_PARAMETER_NAME);
        if (state == null) {
            throw new AuthError(String.format("Response does not have a state parameter: %s", this.uri.toString()), AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        HashMap<String, String> stateValues = new HashMap<String, String>();
        for (String attribute : attributes = TextUtils.split((String)state, (String)"&")) {
            String[] attributeTuple = TextUtils.split((String)attribute, (String)"=");
            if (attributeTuple == null || attributeTuple.length != 2) continue;
            stateValues.put(attributeTuple[0], attributeTuple[1]);
        }
        return stateValues;
    }
}

