/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.api.authorization;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.api.Listener;
import com.amazon.identity.auth.device.api.authorization.AuthCancellation;
import com.amazon.identity.auth.device.api.authorization.AuthorizeResult;
import com.amazon.identity.auth.device.api.authorization.User;
import com.amazon.identity.auth.device.authorization.AuthorizationResponseProcessor;
import com.amazon.identity.auth.device.authorization.api.AuthorizationListener;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.interactive.InteractiveListener;
import com.amazon.identity.auth.device.interactive.InteractiveRequestRecord;
import com.amazon.identity.auth.device.workflow.WorkflowCancellation;
import com.amazon.identity.auth.map.device.utils.MAPLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthorizeListener
implements InteractiveListener<AuthorizeResult, AuthCancellation, AuthError> {
    private static final String LOG_TAG = AuthorizeListener.class.getName();

    @Override
    public abstract void onSuccess(AuthorizeResult var1);

    @Override
    public abstract void onError(AuthError var1);

    @Override
    public abstract void onCancel(AuthCancellation var1);

    @Override
    public final String getRequestType() {
        return "com.amazon.identity.auth.device.authorization.request.authorize";
    }

    @Override
    public final void onRequestCompletion(final Context context, InteractiveRequestRecord request, Uri uri) {
        Bundle requestExtras = request.getRequestExtras();
        String[] requestedScopes = requestExtras.getStringArray("requestedScopes");
        final boolean shouldReturnUserData = requestExtras.getBoolean("shouldReturnUserData");
        AuthorizationResponseProcessor.handleResponse(context, uri, requestedScopes, true, new AuthorizationListener(){

            public void onSuccess(Bundle response) {
                AuthorizeListener.onAuthorizationSuccess(context, response, AuthorizeListener.this, shouldReturnUserData);
            }

            public void onError(AuthError e) {
                AuthorizeListener.this.onError(e);
            }

            public void onCancel(Bundle cause) {
                AuthorizeListener.this.onCancel(new AuthCancellation(cause));
            }
        });
    }

    @Override
    public final void onRequestError(Context context, InteractiveRequestRecord request, Exception e) {
        if (e instanceof AuthError) {
            this.onError((AuthError)e);
        } else {
            this.onError(new AuthError("Could not complete the authorization request", e, AuthError.ERROR_TYPE.ERROR_UNKNOWN));
        }
    }

    @Override
    public final void onRequestCancel(Context context, InteractiveRequestRecord request, WorkflowCancellation cancellation) {
        MAPLog.e(LOG_TAG, "Unexpected invocation of onRequestCancel");
    }

    static void onAuthorizationSuccess(Context context, Bundle authResponse, InteractiveListener<AuthorizeResult, AuthCancellation, AuthError> listener, boolean shouldReturnUserData) {
        if (authResponse.getString(AuthzConstants.BUNDLE_KEY.AUTHORIZATION_CODE.val) == null && shouldReturnUserData) {
            AuthorizeListener.onAuthFetchingUserData(context, authResponse, listener);
        } else {
            listener.onSuccess(new AuthorizeResult(authResponse));
        }
    }

    static void onAuthFetchingUserData(Context context, final Bundle authResponse, final InteractiveListener<AuthorizeResult, AuthCancellation, AuthError> listener) {
        MAPLog.i(LOG_TAG, "Fetching User as part of authorize request");
        User.fetch(context, new Listener<User, AuthError>(){

            @Override
            public void onSuccess(User user) {
                listener.onSuccess(new AuthorizeResult(authResponse, user));
            }

            @Override
            public void onError(AuthError ae) {
                listener.onError(ae);
            }
        });
    }
}

