/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import com.amazon.identity.auth.device.AbstractRequest;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.CompatibilityUtil;
import com.amazon.identity.auth.map.device.utils.MAPLog;

public class ExternalBrowserManager {
    private static final String LOG_TAG = ExternalBrowserManager.class.getName();
    private static final String BROWSER_ID_SUFFIX = ".amazon.auth";

    public void openUrl(AbstractRequest request, String url, Context context) throws AuthError {
        CompatibilityUtil.assertCorrectManifestIntegration(context);
        Intent intent = this.getIntent(url, context);
        MAPLog.i(LOG_TAG, "Starting External Browser");
        try {
            request.onStart();
            context.startActivity(intent);
        }
        catch (Exception e) {
            MAPLog.e(LOG_TAG, "Unable to Launch Browser: " + e.getMessage());
            throw new AuthError("Unable to Launch Browser.", e, AuthError.ERROR_TYPE.ERROR_UNKNOWN);
        }
    }

    private Intent getIntent(String url, Context context) {
        Uri uri = Uri.parse((String)url);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.addFlags(0x10000000);
        intent.addFlags(0x40000000);
        intent.putExtra("com.android.browser.application_id", context.getPackageName() + BROWSER_ID_SUFFIX);
        return intent;
    }
}

