/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.endpoint.AbstractOauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthTokenResponse;
import com.amazon.identity.auth.device.endpoint.TokenResponse;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;

class OauthTokenRequest
extends AbstractOauthTokenRequest {
    private static final String LOG_TAG = OauthTokenRequest.class.getName();
    private final RefreshAtzToken mRefreshToken;

    OauthTokenRequest(String appName, String appVersion, String libVersion, Bundle options, Context context, RefreshAtzToken refreshToken, AppInfo appInfo) throws AuthError {
        super(appName, appVersion, libVersion, context, options, appInfo);
        this.mRefreshToken = refreshToken;
    }

    public String getGrantType() {
        return "refresh_token";
    }

    protected TokenResponse generateTokenResponse(HttpResponse httpResponse) {
        return new OauthTokenResponse(httpResponse, this.getAppFamilyId(), null);
    }

    public HttpResponse executeRequest() throws ClientProtocolException, IOException {
        MAPLog.pii(LOG_TAG, "Oauth Access Exchange executeRequest. appId=" + this.getAppFamilyId(), "refreshAtzToken=" + this.mRefreshToken.toString());
        return super.executeRequest();
    }

    protected void addRequestInfoParameters() throws AuthError {
        super.addRequestInfoParameters();
        this.postParameters.add(new BasicNameValuePair("refresh_token", this.mRefreshToken.toString()));
    }
}

