/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.system;

import android.util.Log;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.SendEvent;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class OpenDownchannel
extends SendEvent {
    private static final String TAG = "OpenDownchannel";

    public OpenDownchannel(String url, String accessToken, AsyncCallback<AvsResponse, Exception> callback) throws IOException {
        if (callback != null) {
            callback.start();
        }
        Log.i((String)TAG, (String)"Starting Open Downchannel procedure");
        long start = System.currentTimeMillis();
        try {
            this.prepareConnection(url, accessToken);
            if (callback != null) {
                callback.success(this.completeGet());
                callback.complete();
            } else {
                this.completeGet();
            }
            Log.i((String)TAG, (String)"Downchannel open");
            Log.i((String)TAG, (String)("Open Downchannel process took: " + (System.currentTimeMillis() - start)));
        }
        catch (IOException e) {
            this.onError(callback, e);
        }
        catch (AvsException e) {
            this.onError(callback, e);
        }
    }

    private void onError(AsyncCallback<AvsResponse, Exception> callback, Exception e) {
        if (callback != null) {
            callback.failure(e);
            callback.complete();
        }
    }

    @Override
    @NotNull
    protected String getEvent() {
        return "";
    }
}

