/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.interfaces.speechrecognizer;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.willblaschko.android.alexa.VoiceHelper;
import com.willblaschko.android.alexa.callbacks.AsyncCallback;
import com.willblaschko.android.alexa.interfaces.AvsException;
import com.willblaschko.android.alexa.interfaces.AvsResponse;
import com.willblaschko.android.alexa.interfaces.speechrecognizer.SpeechSendEvent;
import com.willblaschko.android.alexa.requestbody.DataRequestBody;
import java.io.IOException;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;

public class SpeechSendText
extends SpeechSendEvent {
    private static final String TAG = "SpeechSendText";
    long start = 0L;

    public void sendText(Context context, String url, String accessToken, String text, final AsyncCallback<AvsResponse, Exception> callback) throws IOException {
        if (callback != null) {
            callback.start();
        }
        Log.i((String)TAG, (String)"Starting SpeechSendText procedure");
        this.start = System.currentTimeMillis();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            text = text + ".....";
        }
        String input = text;
        this.prepareConnection(url, accessToken);
        VoiceHelper voiceHelper = VoiceHelper.getInstance(context);
        voiceHelper.getSpeechFromText(input, new VoiceHelper.SpeechFromTextCallback(){

            @Override
            public void onSuccess(byte[] data) {
                Log.i((String)SpeechSendText.TAG, (String)"We have audio");
                try {
                    SpeechSendText.this.mOutputStream.write(data);
                    Log.i((String)SpeechSendText.TAG, (String)"Audio sent");
                    Log.i((String)SpeechSendText.TAG, (String)("Audio creation process took: " + (System.currentTimeMillis() - SpeechSendText.this.start)));
                    if (callback != null) {
                        callback.success(SpeechSendText.this.completePost());
                        callback.complete();
                    }
                }
                catch (IOException e) {
                    this.onError(e);
                }
                catch (AvsException e) {
                    this.onError(e);
                }
            }

            @Override
            public void onError(Exception e) {
                if (callback != null) {
                    callback.failure(e);
                    callback.complete();
                }
            }
        });
    }

    @Override
    @NotNull
    protected RequestBody getRequestBody() {
        return new DataRequestBody(){

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(SpeechSendText.this.mOutputStream.toByteArray());
            }
        };
    }
}

