/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.authorization.ThirdPartyServiceHelper;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.dataobject.RequestedScope;
import com.amazon.identity.auth.device.datastore.AuthorizationTokenDataSource;
import com.amazon.identity.auth.device.datastore.ProfileDataSource;
import com.amazon.identity.auth.device.datastore.RequestedScopeDataSource;
import com.amazon.identity.auth.device.endpoint.ServerCommunication;
import com.amazon.identity.auth.device.token.AccessAtzToken;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenVendor {
    private static final String LOG_TAG = TokenVendor.class.getName();
    protected ServerCommunication mServerCommunication = new ServerCommunication();

    public void setServerCommunication(ServerCommunication serverCommunication) {
        this.mServerCommunication = serverCommunication;
    }

    public String vendToken(String directedId, String[] scopes, Context context, Bundle options, AppInfo appInfo) throws IOException, AuthError {
        MAPLog.pii(LOG_TAG, "Vending out token: appId=" + appInfo.getAppFamilyId() + ", scopes=" + Arrays.toString(scopes), "directedId=" + directedId);
        if (scopes == null || scopes.length == 0) {
            MAPLog.i(LOG_TAG, "Vend token - No scopes passed in");
        }
        RequestedScope[] requestedScopes = this.getRequestedScopes(directedId, appInfo.getAppFamilyId(), scopes, context);
        AccessAtzToken commonAccessToken = TokenVendor.getCommonAccessToken(requestedScopes, context);
        RefreshAtzToken commonRefreshToken = TokenVendor.getCommonRefreshToken(requestedScopes, context);
        if (commonAccessToken != null && commonAccessToken.isRemainingLifeAcceptable()) {
            MAPLog.i(LOG_TAG, "Common token still has acceptable life, returning it back to caller");
            return commonAccessToken.getTokenValue();
        }
        return this.updateExistingToken(commonRefreshToken, directedId, scopes, commonAccessToken, context, options, appInfo);
    }

    public RequestedScope[] getRequestedScopes(String directedId, String appId, String[] scopes, Context context) {
        RequestedScope[] requestedScopes = new RequestedScope[scopes.length];
        for (int i = 0; i < requestedScopes.length; ++i) {
            RequestedScope rs = RequestedScopeDataSource.getInstance(context).findByPrimaryKey(scopes[i], appId, directedId);
            if (rs != null) {
                requestedScopes[i] = rs;
                continue;
            }
            MAPLog.w(LOG_TAG, "RequestedScope shouldn't be null!!!! - " + rs + ", but continuing anyway...");
            requestedScopes[i] = new RequestedScope(scopes[i], appId, directedId);
        }
        return requestedScopes;
    }

    public List<RequestedScope> getCachedScopes(String directedId, String appId, Context context) {
        List<RequestedScope> cachedScopes = RequestedScopeDataSource.getInstance(context).findAllRows();
        return cachedScopes;
    }

    public Bundle vendNewTokensFromCode(String code, String redirectUri, String[] scopes, String directedId, AppInfo appInfo, Context context) throws IOException, AuthError {
        return this.vendNewTokensFromCode(code, null, redirectUri, scopes, directedId, context, false, appInfo);
    }

    public Bundle vendNewTokensFromCode(String code, String codeVerifier, String redirectUri, String[] scopes, String directedId, Context context, boolean isSandBoxMode, AppInfo appInfo) throws IOException, AuthError {
        if (scopes == null || scopes.length == 0) {
            throw new AuthError("No scopes provided in parameters", AuthError.ERROR_TYPE.ERROR_BAD_API_PARAM);
        }
        MAPLog.i(LOG_TAG, "Vending new tokens from Code");
        AuthorizationToken[] tokens = this.mServerCommunication.getTokensFromCode(code, codeVerifier, redirectUri, scopes, directedId, context, isSandBoxMode, appInfo);
        if (tokens == null) {
            throw new AuthError("No tokens returned", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        AccessAtzToken accessAtzToken = (AccessAtzToken)tokens[0];
        if (accessAtzToken == null) {
            throw new AuthError("Access Atz token was null from server communication", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        this.insertToken(context, accessAtzToken);
        RefreshAtzToken refreshAtzToken = (RefreshAtzToken)tokens[1];
        if (refreshAtzToken == null) {
            throw new AuthError("Refresh Atz token was null from server communication", AuthError.ERROR_TYPE.ERROR_SERVER_REPSONSE);
        }
        this.insertToken(context, refreshAtzToken);
        this.updateRequestedScopes(appInfo.getAppFamilyId(), scopes, context, accessAtzToken, refreshAtzToken, directedId);
        Bundle results = new Bundle();
        results.putString(AuthzConstants.BUNDLE_KEY.AUTHORIZE.val, "authorized");
        return results;
    }

    protected void insertToken(Context context, AuthorizationToken atzToken) throws AuthError {
        if (atzToken.insert(context) == -1L) {
            throw new AuthError("Unable to insert " + atzToken.getType() + " token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
        }
    }

    protected void updateRequestedScopes(String appId, String[] scopes, Context context, AccessAtzToken accessAtzToken, RefreshAtzToken refeshAtzToken, String directedId) {
        RequestedScope[] requestedScopes;
        for (RequestedScope rs : requestedScopes = this.getRequestedScopes(directedId, appId, scopes, context)) {
            if (rs.getRowId() == -1L) {
                rs.setAuthorizationAccessTokenId(accessAtzToken.getRowId());
                rs.setAuthorizationRefreshTokenId(refeshAtzToken.getRowId());
                MAPLog.i(LOG_TAG, "Inserting " + rs + " : rowid=" + rs.insert(context));
                continue;
            }
            AuthorizationToken oldAccessToken = (AuthorizationToken)accessAtzToken.getDataSource(context).findByRowId(rs.getAuthorizationAccessTokenId());
            if (oldAccessToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old access token.", "accessAtzToken=" + oldAccessToken + " : " + oldAccessToken.delete(context));
            }
            rs.setAuthorizationAccessTokenId(accessAtzToken.getRowId());
            AuthorizationToken oldRefreshToken = (AuthorizationToken)refeshAtzToken.getDataSource(context).findByRowId(rs.getAuthorizationRefreshTokenId());
            if (oldRefreshToken != null) {
                MAPLog.pii(LOG_TAG, "Deleting old refresh token ", "refreshAtzToken=" + oldRefreshToken + " : " + oldRefreshToken.delete(context));
            }
            rs.setAuthorizationRefreshTokenId(refeshAtzToken.getRowId());
            MAPLog.i(LOG_TAG, "Updating " + rs + " : " + rs.update(context));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateExistingToken(RefreshAtzToken refreshAtzToken, String directedId, String[] scopes, AccessAtzToken accessAtzToken, Context context, Bundle options, AppInfo appInfo) throws IOException, AuthError {
        AuthorizationToken newAccessToken;
        block11: {
            MAPLog.pii(LOG_TAG, "Updating existing token", "token=" + accessAtzToken);
            newAccessToken = null;
            try {
                if (refreshAtzToken == null) break block11;
                if (scopes == null || scopes.length == 0) {
                    String string = null;
                    return string;
                }
                AuthorizationToken[] newTokens = this.mServerCommunication.getAuthorizationTokens(refreshAtzToken, directedId, scopes, context, options, appInfo);
                newAccessToken = newTokens[0];
                if (newTokens[1] != null) {
                    MAPLog.pii(LOG_TAG, "Refresh token", "token=" + refreshAtzToken);
                    this.updateExistingRefreshToken(newTokens[1], refreshAtzToken, context);
                    refreshAtzToken = (RefreshAtzToken)newTokens[1];
                }
                if (newAccessToken == null) break block11;
                MAPLog.pii(LOG_TAG, "Refreshed token", "token=" + accessAtzToken);
                boolean updateScopes = false;
                if (accessAtzToken != null) {
                    newAccessToken.setRowId(accessAtzToken.getRowId());
                } else {
                    updateScopes = true;
                }
                ProfileDataSource.getInstance(context).deleteAllRows();
                if (newAccessToken.insertOrUpdate(context)) {
                    if (updateScopes) {
                        this.updateRequestedScopes(appInfo.getAppFamilyId(), scopes, context, (AccessAtzToken)newAccessToken, refreshAtzToken, directedId);
                    }
                    MAPLog.i(LOG_TAG, "Update success!");
                    break block11;
                }
                throw new IOException("Updating token failed unexpectedly!");
            }
            finally {
                ThirdPartyServiceHelper.unbind(context);
            }
        }
        if (newAccessToken != null) {
            return newAccessToken.getTokenValue();
        }
        return null;
    }

    private static AccessAtzToken getCommonAccessToken(RequestedScope[] requestedScopes, Context context) {
        MAPLog.i(LOG_TAG, "Try finding a common access token for requested scopes");
        if (requestedScopes == null || requestedScopes.length == 0) {
            return null;
        }
        AuthorizationTokenDataSource atzDataSource = AuthorizationTokenDataSource.getInstance(context);
        AccessAtzToken to_return = (AccessAtzToken)atzDataSource.findById(requestedScopes[0].getAuthorizationAccessTokenId());
        if (to_return == null) {
            return null;
        }
        for (int i = 1; i < requestedScopes.length; ++i) {
            AuthorizationToken tmp = atzDataSource.findById(requestedScopes[i].getAuthorizationAccessTokenId());
            if (tmp != null && tmp.getRowId() == to_return.getRowId()) continue;
            MAPLog.i(LOG_TAG, "Common access token not found!");
            return null;
        }
        MAPLog.pii(LOG_TAG, "Common access token found.", "accessAtzToken=" + to_return);
        return to_return;
    }

    private static RefreshAtzToken getCommonRefreshToken(RequestedScope[] requestedScopes, Context context) {
        MAPLog.i(LOG_TAG, "Try finding a common refresh token for requested scopes");
        if (requestedScopes == null || requestedScopes.length == 0) {
            return null;
        }
        AuthorizationTokenDataSource atzDataSource = AuthorizationTokenDataSource.getInstance(context);
        RefreshAtzToken to_return = (RefreshAtzToken)atzDataSource.findById(requestedScopes[0].getAuthorizationRefreshTokenId());
        if (to_return == null) {
            return null;
        }
        for (int i = 1; i < requestedScopes.length; ++i) {
            AuthorizationToken tmp = atzDataSource.findById(requestedScopes[i].getAuthorizationRefreshTokenId());
            if (tmp != null && tmp.getRowId() == to_return.getRowId()) continue;
            MAPLog.i(LOG_TAG, "Common refresh token not found!");
            return null;
        }
        MAPLog.pii(LOG_TAG, "Common refresh token found.", "refreshAtzToken=" + to_return);
        return to_return;
    }

    public void insertTokens(Context context, AccessAtzToken accessAtzToken, RefreshAtzToken refreshAtzToken, String directedId, String appId, String[] scopes) throws AuthError {
        long accessTokenRowId = accessAtzToken.insert(context);
        if (accessTokenRowId == -1L) {
            throw new AuthError("Unable to insert access atz token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
        }
        accessAtzToken.setId(accessTokenRowId);
        long refreshTokenRowId = refreshAtzToken.insert(context);
        if (refreshTokenRowId == -1L) {
            throw new AuthError("Unable to insert refresh token into db", AuthError.ERROR_TYPE.ERROR_DATA_STORAGE);
        }
        refreshAtzToken.setId(refreshTokenRowId);
        this.updateRequestedScopes(appId, scopes, context, accessAtzToken, refreshAtzToken, directedId);
    }

    private void updateExistingRefreshToken(AuthorizationToken newToken, AuthorizationToken existingToken, Context context) throws IOException {
        newToken.setRowId(existingToken.getRowId());
        if (!newToken.update(context)) {
            throw new IOException("Updating token failed unexpectedly!");
        }
    }
}

