/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.identity.auth.device.endpoint;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Bundle;
import com.amazon.identity.auth.device.AuthError;
import com.amazon.identity.auth.device.InvalidGrantAuthError;
import com.amazon.identity.auth.device.authorization.api.AuthzConstants;
import com.amazon.identity.auth.device.dataobject.AppInfo;
import com.amazon.identity.auth.device.dataobject.AuthorizationToken;
import com.amazon.identity.auth.device.datastore.DatabaseHelper;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthCodeForTokenResponse;
import com.amazon.identity.auth.device.endpoint.OauthTokenRequest;
import com.amazon.identity.auth.device.endpoint.OauthTokenResponse;
import com.amazon.identity.auth.device.endpoint.ProfileRequest;
import com.amazon.identity.auth.device.endpoint.ProfileResponse;
import com.amazon.identity.auth.device.token.RefreshAtzToken;
import com.amazon.identity.auth.map.device.utils.MAPLog;
import java.io.IOException;
import java.util.Arrays;
import org.json.JSONObject;

public class ServerCommunication {
    private static final String LOG_TAG = ServerCommunication.class.getName();

    public AuthorizationToken[] getAuthorizationTokens(RefreshAtzToken refreshAtzToken, String directedId, String[] scopes, Context context, Bundle options, AppInfo appInfo) throws IOException, AuthError {
        MAPLog.i(LOG_TAG, "getAuthorizationTokens : appId=" + appInfo.getAppFamilyId() + ", scopes=" + Arrays.toString(scopes));
        ServerCommunication.checkNetwork(context);
        String appName = ServerCommunication.getAppName(context);
        String version = ServerCommunication.getVersion(context);
        if (options == null) {
            options = new Bundle();
        }
        OauthTokenRequest request = new OauthTokenRequest(appName, version, "2.0.1", options, context, refreshAtzToken, appInfo);
        try {
            OauthTokenResponse response = (OauthTokenResponse)request.submit();
            response.parse();
            return response.getAtzTokens();
        }
        catch (InvalidGrantAuthError e) {
            MAPLog.e(LOG_TAG, "Invalid grant request given to the server. Cleaning up local state");
            DatabaseHelper.clearAuthorizationState(context);
            throw e;
        }
    }

    public AuthorizationToken[] getTokensFromCode(String code, String redirectUri, String[] scopes, String directedId, AppInfo appInfo, Context context) throws IOException, AuthError {
        return this.getTokensFromCode(code, null, redirectUri, scopes, directedId, context, false, appInfo);
    }

    public AuthorizationToken[] getTokensFromCode(String code, String codeVerifier, String redirectUri, String[] scopes, String directedId, Context context, boolean isSandboxMode, AppInfo appInfo) throws IOException, AuthError {
        MAPLog.i(LOG_TAG, "getTokensFromCode : appId=" + appInfo.getAppFamilyId() + ", scopes=" + Arrays.toString(scopes));
        ServerCommunication.checkNetwork(context);
        String appName = ServerCommunication.getAppName(context);
        String version = ServerCommunication.getVersion(context);
        Bundle options = new Bundle();
        options.putBoolean(AuthzConstants.BUNDLE_KEY.SANDBOX.val, isSandboxMode);
        OauthCodeForTokenRequest request = new OauthCodeForTokenRequest(appName, version, "2.0.1", options, code, codeVerifier, redirectUri, directedId, appInfo, context);
        OauthCodeForTokenResponse response = (OauthCodeForTokenResponse)request.submit();
        response.parse();
        return response.getAtzTokens();
    }

    private static String getVersion(Context context) {
        try {
            return context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            MAPLog.w(LOG_TAG, "Unable to get verison info from app" + e.getMessage());
            return "N/A";
        }
    }

    private static String getAppName(Context context) {
        ApplicationInfo ai;
        PackageManager pm = context.getApplicationContext().getPackageManager();
        try {
            ai = pm.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        return ai != null ? pm.getApplicationLabel(ai) : context.getPackageName();
    }

    private static void checkNetwork(Context context) throws IOException {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null || cm.getActiveNetworkInfo() == null) {
            throw new IOException("Network is not available!");
        }
    }

    public JSONObject getProfile(Context context, String authzToken, Bundle options, AppInfo appInfo) throws AuthError, IOException {
        ServerCommunication.checkNetwork(context);
        ProfileRequest request = new ProfileRequest(ServerCommunication.getAppName(context), ServerCommunication.getVersion(context), "2.0.1", options, authzToken, context, appInfo);
        ProfileResponse response = (ProfileResponse)request.submit();
        response.parse();
        return response.getProfileResponse();
    }
}

