/*
 * Decompiled with CFR 0.152.
 */
package com.willblaschko.android.alexa.data;

import android.text.TextUtils;

public class Directive {
    private Header header;
    private Payload payload;
    private static final String TYPE_SPEAK = "Speak";
    private static final String TYPE_PLAY = "Play";
    private static final String TYPE_SET_ALERT = "SetAlert";
    private static final String TYPE_SET_VOLUME = "SetVolume";
    private static final String TYPE_ADJUST_VOLUME = "AdjustVolume";
    private static final String TYPE_SET_MUTE = "SetMute";
    private static final String TYPE_EXPECT_SPEECH = "ExpectSpeech";
    private static final String TYPE_MEDIA_PLAY = "PlayCommandIssued";
    private static final String TYPE_MEDIA_PAUSE = "PauseCommandIssued";
    private static final String TYPE_MEDIA_NEXT = "NextCommandIssued";
    private static final String TYPE_MEDIA_PREVIOUS = "PreviousCommandIssue";
    private static final String PLAY_BEHAVIOR_REPLACE_ALL = "REPLACE_ALL";
    private static final String PLAY_BEHAVIOR_ENQUEUE = "ENQUEUE";
    private static final String PLAY_BEHAVIOR_REPLACE_ENQUEUED = "REPLACE_ENQUEUED";

    public boolean isTypeSpeak() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_SPEAK);
    }

    public boolean isTypePlay() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_PLAY);
    }

    public boolean isTypeSetAlert() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_SET_ALERT);
    }

    public boolean isTypeSetVolume() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_SET_VOLUME);
    }

    public boolean isTypeAdjustVolume() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_ADJUST_VOLUME);
    }

    public boolean isTypeSetMute() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_SET_MUTE);
    }

    public boolean isTypeExpectSpeech() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_EXPECT_SPEECH);
    }

    public boolean isTypeMediaPlay() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_MEDIA_PLAY);
    }

    public boolean isTypeMediaPause() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_MEDIA_PAUSE);
    }

    public boolean isTypeMediaNext() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_MEDIA_NEXT);
    }

    public boolean isTypeMediaPrevious() {
        return TextUtils.equals((CharSequence)this.header.getName(), (CharSequence)TYPE_MEDIA_PREVIOUS);
    }

    public boolean isPlayBehaviorReplaceAll() {
        return TextUtils.equals((CharSequence)this.payload.getPlayBehavior(), (CharSequence)PLAY_BEHAVIOR_REPLACE_ALL);
    }

    public boolean isPlayBehaviorEnqueue() {
        return TextUtils.equals((CharSequence)this.payload.getPlayBehavior(), (CharSequence)PLAY_BEHAVIOR_ENQUEUE);
    }

    public boolean isPlayBehaviorReplaceEnqueued() {
        return TextUtils.equals((CharSequence)this.payload.getPlayBehavior(), (CharSequence)PLAY_BEHAVIOR_REPLACE_ENQUEUED);
    }

    public Header getHeader() {
        return this.header;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public static class DirectiveWrapper {
        Directive directive;

        public Directive getDirective() {
            return this.directive;
        }
    }

    public static class Stream {
        String url;
        String streamFormat;
        long offsetInMilliseconds;
        String expiryTime;
        String token;
        String expectedPreviousToken;

        public String getUrl() {
            return this.url;
        }

        public String getStreamFormat() {
            return this.streamFormat;
        }

        public long getOffsetInMilliseconds() {
            return this.offsetInMilliseconds;
        }

        public String getExpiryTime() {
            return this.expiryTime;
        }

        public String getToken() {
            return this.token;
        }

        public String getExpectedPreviousToken() {
            return this.expectedPreviousToken;
        }
    }

    public static class AudioItem {
        String audioItemId;
        Stream stream;

        public String getAudioItemId() {
            return this.audioItemId;
        }

        public Stream getStream() {
            return this.stream;
        }
    }

    public static class Payload {
        String url;
        String format;
        String token;
        String type;
        String scheduledTime;
        String playBehavior;
        AudioItem audioItem;
        long volume;
        boolean mute;
        long timeoutInMilliseconds;

        public String getUrl() {
            return this.url;
        }

        public String getFormat() {
            return this.format;
        }

        public String getToken() {
            return this.token;
        }

        public String getType() {
            return this.type;
        }

        public String getScheduledTime() {
            return this.scheduledTime;
        }

        public String getPlayBehavior() {
            return this.playBehavior;
        }

        public AudioItem getAudioItem() {
            return this.audioItem;
        }

        public long getVolume() {
            return this.volume;
        }

        public boolean isMute() {
            return this.mute;
        }

        public long getTimeoutInMilliseconds() {
            return this.timeoutInMilliseconds;
        }
    }

    public static class Header {
        String namespace;
        String name;
        String messageId;
        String dialogRequestId;

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public String getDialogRequestId() {
            return this.dialogRequestId;
        }
    }
}

