/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.util;

import com.pax.market.api.sdk.java.base.util.AlgHelper;
import com.pax.market.api.sdk.java.base.util.KeyUtils;
import com.pax.market.api.sdk.java.base.util.StringUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtils {
    private static final Logger logger = LoggerFactory.getLogger(CryptoUtils.class);
    private static final String AES = "AES";
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    public static final int DEFAULT_AES_KEY_SIZE = 128;
    public static final int DEFAULT_IV_SIZE = 16;
    private static SecureRandom random = new SecureRandom();

    private CryptoUtils() {
    }

    public static String signRequest(Map<String, String> params, String secret, String signMethod) throws IOException, GeneralSecurityException {
        return CryptoUtils.signRequest(params, null, secret, signMethod);
    }

    public static String signRequest(Map<String, String> params, String body, String secret, String signMethod) throws IOException, GeneralSecurityException {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        if (body != null) {
            query.append(body);
        }
        if ("hmac".equals(signMethod)) {
            bytes = CryptoUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = CryptoUtils.encryptMD5(query.toString());
        }
        return CryptoUtils.byte2hex(bytes);
    }

    public static String signRequest(String queryString, String body, String secret, String signMethod) throws IOException, GeneralSecurityException {
        byte[] bytes;
        StringBuilder query = new StringBuilder();
        if (queryString != null) {
            query.append(queryString);
        }
        if (body != null) {
            query.append(body);
        }
        if ("hmac".equals(signMethod)) {
            bytes = CryptoUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = CryptoUtils.encryptMD5(query.toString());
        }
        return CryptoUtils.byte2hex(bytes);
    }

    private static byte[] encryptHMAC(String data, String secret) throws GeneralSecurityException, IOException {
        SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacMD5");
        Mac mac = Mac.getInstance(secretKey.getAlgorithm());
        mac.init(secretKey);
        byte[] bytes = mac.doFinal(data.getBytes("UTF-8"));
        return bytes;
    }

    public static byte[] encryptMD5(String data) throws IOException, GeneralSecurityException {
        return CryptoUtils.encryptMD5(data.getBytes("UTF-8"));
    }

    public static byte[] encryptMD5(byte[] data) throws IOException, GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] bytes = md.digest(data);
        return bytes;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static String aesEncrypt(String input, String secret) {
        byte[] secretBytes = AlgHelper.hexStringToBytes(secret);
        byte[] secretKey = KeyUtils.genSecretKey(secretBytes);
        String result = null;
        try {
            result = CryptoUtils.bytesToHexString(CryptoUtils.aesEncrypt(input.getBytes("UTF-8"), secretKey));
        }
        catch (Exception e) {
            logger.error("AES encrypt ex", (Throwable)e);
        }
        return result;
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key) {
        return CryptoUtils.aes(input, key, 1);
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, byte[] iv) {
        return CryptoUtils.aes(input, key, iv, 1);
    }

    public static String aesDecrypt(String input, String secret) {
        byte[] secretBytes = AlgHelper.hexStringToBytes(secret);
        byte[] secretKey = KeyUtils.genSecretKey(secretBytes);
        String result = null;
        try {
            result = new String(CryptoUtils.aesDecrypt(CryptoUtils.hexStringToBytes(input), secretKey), "UTF-8");
        }
        catch (Exception e) {
            logger.error("AES decrypt ex", (Throwable)e);
        }
        return result;
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key) {
        return CryptoUtils.aes(input, key, 2);
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key, byte[] iv) {
        return CryptoUtils.aes(input, key, iv, 2);
    }

    private static byte[] aes(byte[] input, byte[] key, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            Cipher cipher = Cipher.getInstance(AES);
            cipher.init(mode, secretKey);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            logger.error("AES ex, mode:{}", (Object)mode, (Object)e);
            return null;
        }
    }

    private static byte[] aes(byte[] input, byte[] key, byte[] iv, int mode) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, AES);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(AES_CBC);
            cipher.init(mode, (Key)secretKey, ivSpec);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            logger.error("AES encrypt ex", (Throwable)e);
            return null;
        }
    }

    public static byte[] generateAesKey(int keysize) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(AES);
            keyGenerator.init(keysize);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (GeneralSecurityException e) {
            logger.error("AES encrypt ex", (Throwable)e);
            return null;
        }
    }

    public static byte[] generateIV() {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return bytes;
    }

    public static String bytesToHexString(byte[] paramArrayOfByte) {
        StringBuilder localStringBuilder = new StringBuilder();
        if (paramArrayOfByte == null || paramArrayOfByte.length <= 0) {
            return null;
        }
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            int j = paramArrayOfByte[i] & 0xFF;
            String str = Integer.toHexString(j);
            if (str.length() < 2) {
                localStringBuilder.append(0);
            }
            localStringBuilder.append(str);
        }
        return localStringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String paramString) {
        if ((paramString = paramString.toUpperCase()) == null || paramString.equals("")) {
            return null;
        }
        paramString = paramString.toUpperCase();
        int i = paramString.length() / 2;
        char[] arrayOfChar = paramString.toCharArray();
        byte[] arrayOfByte = new byte[i];
        for (int j = 0; j < i; ++j) {
            int k = j * 2;
            arrayOfByte[j] = (byte)(CryptoUtils.charToByte(arrayOfChar[k]) << 4 | CryptoUtils.charToByte(arrayOfChar[k + 1]) & 0xFF);
        }
        return arrayOfByte;
    }

    public static byte charToByte(char paramChar) {
        return (byte)"0123456789ABCDEF".indexOf(paramChar);
    }
}

