/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.client;

import com.pax.market.api.sdk.java.Version;
import com.pax.market.api.sdk.java.base.constant.ResultCode;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.CryptoUtils;
import com.pax.market.api.sdk.java.base.util.HttpUtils;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClient {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultClient.class.getSimpleName());
    protected String baseUrl;
    protected String appKey;
    protected String appSecret;
    protected String signMethod = "hmac";
    protected int connectTimeout = 30000;
    protected int readTimeout = 30000;
    protected int writeTimeout = 30000;
    private Proxy proxy;
    private String basicAuthorization;
    private PasswordAuthentication passwordAuthentication;

    public DefaultClient(String baseUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.subV1InBaseUrl(baseUrl);
    }

    private void subV1InBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl != null && baseUrl.endsWith("v1") ? baseUrl.substring(0, baseUrl.length() - 2) : baseUrl;
    }

    public DefaultClient(Builder builder) {
        this.subV1InBaseUrl(builder.baseUrl);
        this.appKey = builder.appKey;
        this.appSecret = builder.appSecret;
        this.signMethod = builder.signMethod;
        this.connectTimeout = builder.connectTimeout;
        this.readTimeout = builder.readTimeout;
        this.proxy = builder.proxy;
        this.basicAuthorization = builder.basicAuthorization;
        this.passwordAuthentication = builder.passwordAuthentication;
    }

    public String pingHosts(String dynamicHost, String staticHost) {
        return HttpUtils.pingHosts(dynamicHost, staticHost, this.proxy, this.basicAuthorization, this.passwordAuthentication);
    }

    public String execute(SdkRequest request) {
        try {
            return this._execute(request);
        }
        catch (IOException e) {
            logger.error("IOException occurred when execute request. Details: {}", (Object)e.toString());
            return JsonUtils.getSdkJsonStr(ResultCode.SDK_DOWNLOAD_IOEXCEPTION.getCode(), "IOException-" + e.toString());
        }
        catch (GeneralSecurityException e) {
            logger.error("GeneralSecurityException occurred when execute request. Details: {}", (Object)e.toString());
            return JsonUtils.getSdkJsonStr(ResultCode.SDK_RQUEST_EXCEPTION.getCode(), e.toString());
        }
    }

    private String _execute(SdkRequest request) throws IOException, GeneralSecurityException {
        if (this.appKey != null) {
            request.addHeader("X-3rdApp-Key", this.appKey);
        }
        request.addHeader("X-SDK-Version", Version.getVersion());
        String query = HttpUtils.buildQuery(request.getRequestParams(), "UTF-8");
        if (this.appSecret != null) {
            String signature = CryptoUtils.signRequest(query, request.getRequestBody(), this.appSecret, this.signMethod);
            request.addHeader("signature", signature);
        }
        String requestUrl = HttpUtils.buildRequestUrl(this.baseUrl + request.getRequestMappingUrl(), query);
        String response = HttpUtils.request(requestUrl, request.getRequestMethod(), this.connectTimeout, this.readTimeout, this.writeTimeout, request.getRequestBody(), request.getHeaderMap(), request.getSaveFilePath(), this.proxy, this.basicAuthorization, this.passwordAuthentication);
        return response;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setBasicAuthorization(String basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }

    public void setPasswordAuthentication(PasswordAuthentication passwordAuthentication) {
        this.passwordAuthentication = passwordAuthentication;
    }

    public void setBaseUrl(String baseUrl) {
        this.subV1InBaseUrl(baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static final class Builder {
        String baseUrl;
        String appKey;
        String appSecret;
        String signMethod;
        int connectTimeout;
        int readTimeout;
        int writeTimeout;
        Proxy proxy;
        String basicAuthorization;
        PasswordAuthentication passwordAuthentication;

        public Builder() {
            this.signMethod = "hmac";
            this.connectTimeout = 3000;
            this.readTimeout = 3000;
            this.writeTimeout = 3000;
        }

        Builder(DefaultClient client) {
            this.baseUrl = client.baseUrl;
            this.appKey = client.appKey;
            this.appSecret = client.appSecret;
            this.signMethod = client.signMethod;
            this.connectTimeout = client.connectTimeout;
            this.readTimeout = client.readTimeout;
            this.writeTimeout = client.writeTimeout;
            this.proxy = client.proxy;
            this.basicAuthorization = client.basicAuthorization;
            this.passwordAuthentication = client.passwordAuthentication;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public Builder signMethod(String signMethod) {
            this.signMethod = signMethod;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder readTimeout(int timeout) {
            this.readTimeout = timeout;
            return this;
        }

        public Builder writeTimeout(int timeout) {
            this.writeTimeout = timeout;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder basicAuthorization(String basicAuthorization) {
            this.basicAuthorization = basicAuthorization;
            return this;
        }

        public Builder passwordAuthentication(PasswordAuthentication passwordAuthentication) {
            this.passwordAuthentication = passwordAuthentication;
            return this;
        }

        public DefaultClient build() {
            return new DefaultClient(this);
        }
    }
}

