/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.base.api;

import com.pax.market.api.sdk.java.base.client.DefaultClient;
import com.pax.market.api.sdk.java.base.client.ProxyDelegate;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseApi {
    private final Logger logger = LoggerFactory.getLogger((String)BaseApi.class.getSimpleName());
    private String terminalSN;
    private String appKey;
    private DefaultClient client;

    public BaseApi(String baseUrl, String appKey, String appSecret, String terminalSN) {
        this.terminalSN = terminalSN;
        this.appKey = appKey;
        this.client = new DefaultClient(baseUrl, appKey, appSecret);
    }

    public String getBaseUrl() {
        return this.client.getBaseUrl();
    }

    public String getTerminalSN() {
        return this.terminalSN;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public <T extends BaseApi> T setProxyDelegate(ProxyDelegate proxyDelegate) {
        if (proxyDelegate != null) {
            this.client.setProxy(proxyDelegate.retrieveProxy());
            this.client.setBasicAuthorization(proxyDelegate.retrieveBasicAuthorization());
            this.client.setPasswordAuthentication(proxyDelegate.retrievePasswordAuthentication());
        } else {
            this.logger.warn("Proxy delegate is NULL, please set it before using proxy!");
        }
        return (T)this;
    }

    protected DefaultClient getDefaultClient() {
        return this.client;
    }

    protected DefaultClient getDefaultDownloadClient() {
        return this.client.newBuilder().baseUrl("").build();
    }

    public String call(SdkRequest request) {
        return this.getDefaultClient().execute(request);
    }

    public String pingHosts(String dynamicHost, String staticHost) {
        return this.getDefaultClient().pingHosts(dynamicHost, staticHost);
    }

    public String download(SdkRequest request) {
        return this.getDefaultDownloadClient().execute(request);
    }
}

