/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.update;

import com.pax.market.api.sdk.java.base.api.BaseApi;
import com.pax.market.api.sdk.java.base.dto.UpdateObject;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateApi
extends BaseApi {
    private static final String REQ_PARAM_PACKAGE_NAME = "packageName";
    private static final String REQ_PARAM_VERSION_CODE = "versionCode";
    private final Logger logger = LoggerFactory.getLogger((String)UpdateApi.class.getSimpleName());
    protected static String checkUpdateUrl = "v1/3rdApps/upgrade";

    public UpdateApi(String baseUrl, String appKey, String appSecret, String terminalSN) {
        super(baseUrl, appKey, appSecret, terminalSN);
    }

    public void setBaseUrl(String baseUrl) {
        super.getDefaultClient().setBaseUrl(baseUrl);
    }

    public UpdateObject checkUpdate(int versionCode, String packageName) {
        this.logger.info("Check update >>> ");
        SdkRequest request = new SdkRequest(checkUpdateUrl);
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.addRequestParam(REQ_PARAM_PACKAGE_NAME, packageName);
        request.addRequestParam(REQ_PARAM_VERSION_CODE, Integer.toString(versionCode));
        return JsonUtils.fromJson(this.call(request), UpdateObject.class);
    }
}

