/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.sync;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.sync.dto.AccessoryInfo;
import com.pax.market.api.sdk.java.api.sync.dto.TerminalSyncInfo;
import com.pax.market.api.sdk.java.base.api.BaseApi;
import com.pax.market.api.sdk.java.base.dto.LocationObject;
import com.pax.market.api.sdk.java.base.dto.MerchantObject;
import com.pax.market.api.sdk.java.base.dto.SdkObject;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;

public class SyncApi
extends BaseApi {
    protected static String syncTerminalInfoUrl = "v1/3rdApps/info";
    protected static String reBindUrl = "v1/3rdApps/rki/bind";
    protected static String locationUrl = "v1/3rdApps/location";
    protected static String merchantUrl = "v1/3rdApps/merchant";

    public SyncApi(String baseUrl, String appKey, String appSecret, String terminalSN) {
        super(baseUrl, appKey, appSecret, terminalSN);
    }

    public void setBaseUrl(String baseUrl) {
        super.getDefaultClient().setBaseUrl(baseUrl);
    }

    public SdkObject syncTerminalInfo(List<TerminalSyncInfo> infoList) {
        SdkRequest request = new SdkRequest(syncTerminalInfoUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.setRequestBody(new Gson().toJson(infoList, ArrayList.class));
        return JsonUtils.fromJson(this.call(request), SdkObject.class);
    }

    public SdkObject bindOrUpdateAccessory(AccessoryInfo accessoryInfo) {
        SdkRequest request = new SdkRequest(reBindUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        request.setRequestBody(new Gson().toJson((Object)accessoryInfo));
        return JsonUtils.fromJson(this.call(request), SdkObject.class);
    }

    public MerchantObject getMerchantInfo() {
        SdkRequest request = new SdkRequest(merchantUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        return JsonUtils.fromJson(this.call(request), MerchantObject.class);
    }

    public LocationObject getLocationInfo() {
        SdkRequest request = new SdkRequest(locationUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.GET);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        return JsonUtils.fromJson(this.call(request), LocationObject.class);
    }

    public static interface SyncType {
        public static final int APPLICATION = 1;
        public static final int DEVICE = 2;
        public static final int HARDWARE = 3;
        public static final int INSTALL_HISTORY = 4;
    }
}

