/*
 * Decompiled with CFR 0.152.
 */
package com.pax.market.api.sdk.java.api.sync;

import com.google.gson.Gson;
import com.pax.market.api.sdk.java.api.sync.SyncApi;
import com.pax.market.api.sdk.java.api.sync.dto.TerminalSyncBizData;
import com.pax.market.api.sdk.java.base.api.BaseApi;
import com.pax.market.api.sdk.java.base.dto.SdkObject;
import com.pax.market.api.sdk.java.base.request.SdkRequest;
import com.pax.market.api.sdk.java.base.util.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoInsightApi
extends BaseApi {
    private final Logger logger = LoggerFactory.getLogger((String)SyncApi.class.getSimpleName());
    protected static String sendBusinessDataUrl = "v1/3rdApps/goInsight/data/send";
    private TimeZone timeZone;
    protected static int MAX_MB = 2;
    protected static int ERROR_CODE_PARAMETER_MANDATORY = 1000;
    protected static int ERROR_CODE_GETBYTES_FAILED = 1001;
    protected static int ERROR_CODE_EXCEED_MAX_SIZE = 1002;

    public GoInsightApi(String baseUrl, String appKey, String appSecret, String terminalSN, TimeZone timeZone) {
        super(baseUrl, appKey, appSecret, terminalSN);
        this.timeZone = timeZone;
    }

    public void setBaseUrl(String baseUrl) {
        super.getDefaultClient().setBaseUrl(baseUrl);
    }

    public SdkObject syncTerminalBizData(List bizDataList) {
        if (bizDataList == null || bizDataList.isEmpty()) {
            SdkObject sdkObject = new SdkObject();
            sdkObject.setBusinessCode(ERROR_CODE_PARAMETER_MANDATORY);
            sdkObject.setMessage("Parameter bizDataList should not be null");
            return sdkObject;
        }
        SdkRequest request = new SdkRequest(sendBusinessDataUrl);
        request.setRequestMethod(SdkRequest.RequestMethod.POST);
        request.addHeader("Content-Type", "application/json;charset=utf-8");
        request.addHeader("X-Terminal-SN", this.getTerminalSN());
        TerminalSyncBizData terminalSyncBizData = new TerminalSyncBizData();
        terminalSyncBizData.setBizDataList(bizDataList);
        String bizDataString = new Gson().toJson((Object)terminalSyncBizData);
        int stringByteSize = 0;
        try {
            stringByteSize = bizDataString.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(e.toString());
            SdkObject sdkObject = new SdkObject();
            sdkObject.setBusinessCode(ERROR_CODE_GETBYTES_FAILED);
            sdkObject.setMessage("getBytes() error :" + e.toString());
            return sdkObject;
        }
        double stringMBSize = (double)stringByteSize / 1024.0 / 1024.0;
        if (stringMBSize > (double)MAX_MB) {
            SdkObject sdkObject = new SdkObject();
            sdkObject.setBusinessCode(ERROR_CODE_EXCEED_MAX_SIZE);
            sdkObject.setMessage("list exceeds the max size allow, max list size limits to 2MB");
            return sdkObject;
        }
        request.setRequestBody(bizDataString);
        return JsonUtils.fromJson(this.call(request), SdkObject.class);
    }
}

