/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import com.webauthn4j.util.exception.UnexpectedCheckedException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;

public class ECUtil {
    public static final ECParameterSpec P_256_SPEC = ECUtil.createECParameterSpec("secp256r1");
    public static final ECParameterSpec P_384_SPEC = ECUtil.createECParameterSpec("secp384r1");
    public static final ECParameterSpec P_521_SPEC = ECUtil.createECParameterSpec("secp521r1");

    private ECUtil() {
    }

    public static byte[] createUncompressedPublicKey(ECPublicKey ecPublicKey) {
        byte[] x = ecPublicKey.getW().getAffineX().toByteArray();
        byte[] y = ecPublicKey.getW().getAffineY().toByteArray();
        int xOffset = x.length - 32;
        int yOffset = y.length - 32;
        byte format = 4;
        return ByteBuffer.allocate(65).put(format).put(Arrays.copyOfRange(x, xOffset, xOffset + 32)).put(Arrays.copyOfRange(y, yOffset, yOffset + 32)).array();
    }

    public static PublicKey createPublicKey(ECPublicKeySpec ecPublicKeySpec) {
        try {
            KeyFactory factory = KeyFactory.getInstance("EC");
            return factory.generatePublic(ecPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }

    private static ECParameterSpec createECParameterSpec(String name) {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance("EC");
            parameters.init(new ECGenParameterSpec(name));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new UnexpectedCheckedException(e);
        }
    }
}

