/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.util;

import java.nio.ByteBuffer;
import java.util.UUID;

public class UUIDUtil {
    private UUIDUtil() {
    }

    public static UUID fromString(String value) {
        return UUID.fromString(value);
    }

    public static byte[] convertUUIDToBytes(UUID uuid) {
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        return ByteBuffer.allocate(16).putLong(hi).putLong(lo).array();
    }

    public static UUID fromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long hi = bb.getLong();
        long lo = bb.getLong();
        return new UUID(hi, lo);
    }
}

